/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.junit5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.output.TeeOutputStream;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureConsoleExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureConsoleExtension.class);
    private static final String CAPTURECONSOLESKIP_PROPERTY = "xwiki.surefire.captureconsole.skip";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CaptureConsoleExtension.class});
    private static final String ALL = "all";
    private static final String EACH = "each";
    private static Boolean skip;
    private PrintStream savedOriginalOut;
    private PrintStream savedOriginalErr;
    private Map<String, ByteArrayOutputStream> collectingContentStream = new HashMap<String, ByteArrayOutputStream>();

    public void beforeAll(ExtensionContext extensionContext) {
        this.savedOriginalOut = System.out;
        this.savedOriginalErr = System.err;
        this.captureOutput(ALL);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.captureOutput(EACH);
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.validateOutput(EACH);
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.validateOutput(ALL);
        System.setOut(this.savedOriginalOut);
        System.setOut(this.savedOriginalErr);
    }

    private void captureOutput(String key) {
        if (CaptureConsoleExtension.shouldSkip()) {
            return;
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.collectingContentStream.put(key, stream);
        System.setOut(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)stream, (OutputStream)this.savedOriginalOut)));
        System.setErr(new PrintStream((OutputStream)new TeeOutputStream((OutputStream)stream, (OutputStream)this.savedOriginalErr)));
    }

    private void validateOutput(String key) {
        String outputContent;
        if (CaptureConsoleExtension.shouldSkip()) {
            return;
        }
        if (this.collectingContentStream.containsKey(key) && !(outputContent = this.filteredString(this.collectingContentStream.remove(key).toString())).trim().isEmpty()) {
            throw new AssertionError((Object)String.format("There should be no content output to the console by the test! Instead we got [%s]", outputContent));
        }
    }

    private String filteredString(String outputContent) {
        StringBuilder builder = new StringBuilder();
        boolean insideDebuggingInformation = false;
        String[] lines = outputContent.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (insideDebuggingInformation) {
                if (!line.contains("---- End of environment debugging information")) continue;
                insideDebuggingInformation = false;
                continue;
            }
            if (line.contains("---- Start of environment debugging information")) {
                insideDebuggingInformation = true;
                continue;
            }
            builder.append(line);
            if (i >= lines.length - 1) continue;
            builder.append('\n');
        }
        if (!outputContent.isEmpty()) {
            builder.append('\n');
        }
        return builder.toString();
    }

    private static String getPropertyValue(String propertyName) {
        String value = System.getProperty(propertyName);
        if (value == null) {
            value = CaptureConsoleExtension.getPropertyValueFromPOM(propertyName);
        }
        return value;
    }

    static boolean shouldSkip() {
        if (skip == null) {
            String value = CaptureConsoleExtension.getPropertyValue(CAPTURECONSOLESKIP_PROPERTY);
            skip = Boolean.parseBoolean(value);
        }
        return skip;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getPropertyValueFromPOM(String propertyName) {
        String value = null;
        if (Files.exists(CaptureConsoleExtension.getPOMPath(), new LinkOption[0])) {
            try {
                String content = new String(Files.readAllBytes(CaptureConsoleExtension.getPOMPath()));
                Pattern regex = Pattern.compile(String.format("<%s>(.*)</%s>", propertyName, propertyName), 32);
                Matcher regexMatcher = regex.matcher(content);
                if (!regexMatcher.find()) return value;
                return regexMatcher.group(1).trim();
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Error reading file [%s]", CaptureConsoleExtension.getPOMPath()), e);
            }
        }
        LOGGER.warn("No [{}] file in current directory [{}]", (Object)CaptureConsoleExtension.getPOMPath(), (Object)Paths.get("", new String[0]).toAbsolutePath());
        return value;
    }

    private static Path getPOMPath() {
        return Paths.get("pom.xml", new String[0]);
    }

    private static ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

