/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.xar;

import com.xpn.xwiki.tool.xar.AbstractXarMojo;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;

public class UnXarMojo
extends AbstractXarMojo {
    private static final String TWO_POINTS = ":";
    private static final String DOTDOTDOT = "...";
    private String groupId;
    private String artifactId;
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.outputDirectory.mkdirs();
        try {
            this.performUnArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while expanding the XAR file [" + this.groupId + TWO_POINTS + this.artifactId + "]", e);
        }
    }

    private Artifact findArtifact() throws MojoExecutionException {
        Artifact resolvedArtifact = null;
        this.getLog().debug((CharSequence)("Searching for an artifact that matches [" + this.groupId + TWO_POINTS + this.artifactId + "]" + DOTDOTDOT));
        for (Artifact artifact : this.project.getArtifacts()) {
            this.getLog().debug((CharSequence)("Checking artifact [" + artifact.getGroupId() + TWO_POINTS + artifact.getArtifactId() + TWO_POINTS + artifact.getType() + "]" + DOTDOTDOT));
            if (!artifact.getGroupId().equals(this.groupId) || !artifact.getArtifactId().equals(this.artifactId)) continue;
            resolvedArtifact = artifact;
            break;
        }
        if (resolvedArtifact == null) {
            throw new MojoExecutionException("Artifact [" + this.groupId + TWO_POINTS + this.artifactId + "]" + " is not a dependency of the project.");
        }
        return resolvedArtifact;
    }

    private void performUnArchive() throws ArchiverException, IOException, MojoExecutionException {
        Artifact artifact = this.findArtifact();
        this.getLog().debug((CharSequence)("Source XAR = [" + artifact.getFile() + "]"));
        this.unpack(artifact.getFile(), this.outputDirectory, "UnXarMojo", true);
        this.unpackDependentXars(artifact);
    }

    protected void unpackDependentXars(Artifact artifact) throws MojoExecutionException {
        try {
            Set<Artifact> dependencies = this.resolveArtifactDependencies(artifact);
            for (Artifact dependency : dependencies) {
                this.unpack(dependency.getFile(), this.outputDirectory, "UnXarMojo", false);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to unpack artifact [" + artifact + "] dependencies", e);
        }
    }
}

