/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.tool.xar;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.xwiki.tool.xar.AbstractXARMojo;

public class UnXARMojo
extends AbstractXARMojo {
    private String groupId;
    private String artifactId;
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.outputDirectory.mkdirs();
        try {
            this.performUnArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Error while expanding the XAR file [%s:%s]", this.groupId, this.artifactId), e);
        }
    }

    private Artifact findArtifact() throws MojoExecutionException {
        Artifact resolvedArtifact = null;
        this.getLog().debug((CharSequence)String.format("Searching for an artifact that matches [%s:%s]...", this.groupId, this.artifactId));
        for (Artifact artifact : this.project.getArtifacts()) {
            this.getLog().debug((CharSequence)String.format("Checking artifact [%s:%s:%s]...", artifact.getGroupId(), artifact.getArtifactId(), artifact.getType()));
            if (!artifact.getGroupId().equals(this.groupId) || !artifact.getArtifactId().equals(this.artifactId)) continue;
            resolvedArtifact = artifact;
            break;
        }
        if (resolvedArtifact == null) {
            throw new MojoExecutionException(String.format("Artifact [%s:%s] is not a dependency of the project.", this.groupId, this.artifactId));
        }
        return resolvedArtifact;
    }

    private void performUnArchive() throws ArchiverException, IOException, MojoExecutionException {
        Artifact artifact = this.findArtifact();
        this.getLog().debug((CharSequence)String.format("Source XAR = [%s]", artifact.getFile()));
        this.unpack(artifact.getFile(), this.outputDirectory, "XAR Plugin", true);
        this.unpackDependentXars(artifact);
    }

    protected void unpackDependentXars(Artifact artifact) throws MojoExecutionException {
        try {
            Set<Artifact> dependencies = this.resolveArtifactDependencies(artifact);
            for (Artifact dependency : dependencies) {
                this.unpack(dependency.getFile(), this.outputDirectory, "XAR Plugin", false);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Failed to unpack artifact [%s] dependencies", artifact), e);
        }
    }
}

