/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.velocity.tools.generic.LogTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.util.introspection.DeprecatedCheckUberspector;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.text.StringUtils;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.internal.DefaultToolsInitializer;
import org.xwiki.velocity.internal.util.RestrictParseLocationEventHandler;
import org.xwiki.velocity.introspection.MethodArgumentsUberspector;
import org.xwiki.velocity.introspection.SecureUberspector;
import org.xwiki.velocity.tools.CollectionTool;
import org.xwiki.velocity.tools.ComparisonDateTool;
import org.xwiki.velocity.tools.EscapeTool;
import org.xwiki.velocity.tools.JSONTool;
import org.xwiki.velocity.tools.ObjectTool;
import org.xwiki.velocity.tools.RegexTool;
import org.xwiki.velocity.tools.URLTool;
import org.xwiki.velocity.tools.nio.NIOTool;

@Component
@Singleton
public class DefaultVelocityConfiguration
implements Initializable,
VelocityConfiguration {
    private static final String PREFIX = "velocity.";
    @Inject
    protected LoggerConfiguration loggerConfiguration;
    @Inject
    protected ConfigurationSource configuration;
    @Inject
    protected List<DefaultToolsInitializer> toolsInitializers;
    protected Properties defaultTools = new Properties();
    protected Properties defaultProperties = new Properties();

    public void initialize() throws InitializationException {
        this.defaultTools.setProperty("numbertool", NumberTool.class.getName());
        this.defaultTools.setProperty("datetool", ComparisonDateTool.class.getName());
        this.defaultTools.setProperty("mathtool", MathTool.class.getName());
        this.defaultTools.setProperty("escapetool", EscapeTool.class.getName());
        this.defaultTools.setProperty("regextool", RegexTool.class.getName());
        this.defaultTools.setProperty("collectiontool", CollectionTool.class.getName());
        this.defaultTools.setProperty("stringtool", StringUtils.class.getName());
        this.defaultTools.setProperty("jsontool", JSONTool.class.getName());
        this.defaultTools.setProperty("urltool", URLTool.class.getName());
        this.defaultTools.setProperty("exceptiontool", ExceptionUtils.class.getName());
        this.defaultTools.setProperty("niotool", NIOTool.class.getName());
        this.defaultTools.setProperty("logtool", LogTool.class.getName());
        this.defaultTools.setProperty("objecttool", ObjectTool.class.getName());
        this.toolsInitializers.forEach(l -> l.initialize(this.defaultTools));
        this.defaultProperties.setProperty("velocimacro.max_depth", "100");
        this.defaultProperties.setProperty("resource.manager.log_when_found", Boolean.FALSE.toString());
        this.defaultProperties.setProperty("velocimacro.inline.local_scope", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("velocimacro.inline.replace_global", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("directive.if.empty_check", Boolean.FALSE.toString());
        this.defaultProperties.setProperty("parser.space_gobbling", "bc");
        this.defaultProperties.setProperty("parser.allow_hyphen_in_identifiers", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("velocimacro.enable_bc_mode", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("context.scope_control.template", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("context.scope_control.macro", Boolean.TRUE.toString());
        this.defaultProperties.setProperty("event_handler.include.class", RestrictParseLocationEventHandler.class.getName());
        this.initializeDefaultUberspectors();
    }

    private void initializeDefaultUberspectors() {
        StringBuilder unberspectors = new StringBuilder();
        unberspectors.append(SecureUberspector.class.getName());
        if (this.loggerConfiguration.isDeprecatedLogEnabled()) {
            unberspectors.append(',');
            unberspectors.append(DeprecatedCheckUberspector.class.getName());
        }
        unberspectors.append(',');
        unberspectors.append(MethodArgumentsUberspector.class.getName());
        this.defaultProperties.setProperty("introspector.uberspect.class", unberspectors.toString());
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultProperties);
        Properties configuredProperties = (Properties)this.configuration.getProperty("velocity.properties", Properties.class);
        if (configuredProperties != null) {
            props.putAll((Map<?, ?>)configuredProperties);
        }
        return props;
    }

    @Override
    public Properties getTools() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.defaultTools);
        Properties configuredTools = (Properties)this.configuration.getProperty("velocity.tools", Properties.class);
        if (configuredTools != null) {
            props.putAll((Map<?, ?>)configuredTools);
        }
        return props;
    }
}

