/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityContextInitializer;
import org.xwiki.velocity.XWikiVelocityException;

@Component
public class DefaultVelocityContextFactory
extends AbstractLogEnabled
implements VelocityContextFactory,
Initializable {
    @Requirement
    private ComponentManager componentManager;
    @Requirement
    private VelocityConfiguration velocityConfiguration;
    private Context toolsContext;

    public void initialize() throws InitializationException {
        this.toolsContext = new VelocityContext();
        Properties properties = this.velocityConfiguration.getTools();
        if (properties != null) {
            Enumeration<?> props = properties.propertyNames();
            while (props.hasMoreElements()) {
                Object toolInstance;
                String key = props.nextElement().toString();
                String value = properties.getProperty(key);
                try {
                    toolInstance = Class.forName(value).newInstance();
                }
                catch (Exception e) {
                    throw new InitializationException("Failed to initialize tool [" + value + "]", (Throwable)e);
                }
                this.toolsContext.put(key, toolInstance);
                this.getLogger().debug("Setting tool [" + key + "] = [" + value + "]");
            }
        }
    }

    public VelocityContext createContext() throws XWikiVelocityException {
        VelocityContext context = new VelocityContext(this.toolsContext);
        try {
            for (VelocityContextInitializer interceptor : this.componentManager.lookupList(VelocityContextInitializer.class)) {
                interceptor.initialize(context);
            }
        }
        catch (ComponentLookupException e) {
            throw new XWikiVelocityException("Failed to locate some Velocity Context initializers", e);
        }
        return context;
    }
}

