/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.management.JMXBeanRegistration;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityFactory;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.jmx.JMXVelocityEngine;

@Component
public class DefaultVelocityFactory
extends AbstractLogEnabled
implements VelocityFactory {
    @Requirement
    private ComponentManager componentManager;
    @Requirement
    private JMXBeanRegistration jmxRegistration;
    private Map<String, VelocityEngine> velocityEngines = new HashMap<String, VelocityEngine>();

    public synchronized boolean hasVelocityEngine(String key) {
        return this.velocityEngines.containsKey(key);
    }

    public synchronized VelocityEngine getVelocityEngine(String key) {
        return this.velocityEngines.get(key);
    }

    public synchronized VelocityEngine createVelocityEngine(String key, Properties properties) throws XWikiVelocityException {
        VelocityEngine engine;
        try {
            engine = (VelocityEngine)this.componentManager.lookup(VelocityEngine.class);
        }
        catch (ComponentLookupException e) {
            throw new XWikiVelocityException("Failed to create Velocity Engine", e);
        }
        engine.initialize(properties);
        this.velocityEngines.put(key, engine);
        JMXVelocityEngine mbean = new JMXVelocityEngine(engine);
        this.jmxRegistration.registerMBean((Object)mbean, "type=Velocity,domain=Engines,name=" + key);
        return engine;
    }
}

