/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal.jmx;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.internal.jmx.JMXVelocityEngineMBean;

public class JMXVelocityEngine
implements JMXVelocityEngineMBean {
    private VelocityEngine engine;

    public JMXVelocityEngine(VelocityEngine engine) {
        this.engine = engine;
    }

    @Override
    public TabularData getTemplates() {
        TabularDataSupport data;
        try {
            Map<String, String[]> result = this.getInternalTemplates();
            ArrayType macroNameType = new ArrayType(1, SimpleType.STRING);
            String[] columnNames = new String[]{"templateName", "macroNames"};
            String[] descriptions = new String[]{"The Template Name (namespace)", "The names of registered Macros"};
            CompositeType rowType = new CompositeType("template", "Template management data (namespaces, macros) for a row", columnNames, descriptions, new OpenType[]{SimpleType.STRING, macroNameType});
            TabularType type = new TabularType("templates", "Template management data (namespaces, macros)", rowType, columnNames);
            data = new TabularDataSupport(type);
            for (Map.Entry<String, String[]> entry : result.entrySet()) {
                String templateName = entry.getKey();
                String[] macroNames = entry.getValue();
                CompositeDataSupport rowData = new CompositeDataSupport(rowType, columnNames, new Object[]{templateName, macroNames});
                data.put(rowData);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to gather information on Velocity Templates/Macros", e);
        }
        return data;
    }

    private Map<String, String[]> getInternalTemplates() throws NoSuchFieldException, IllegalAccessException {
        Object velocityEngine = this.getField(this.engine, "engine");
        Object runtimeInstance = this.getField(velocityEngine, "ri");
        Object vmFactory = this.getField(runtimeInstance, "vmFactory");
        Object vmManager = this.getField(vmFactory, "vmManager");
        Map namespaceHash = (Map)this.getField(vmManager, "namespaceHash");
        Map globalNamespace = (Map)this.getField(vmManager, "globalNamespace");
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Iterator i$ = namespaceHash.keySet().iterator();
        while (i$.hasNext()) {
            String name;
            String nameSpaceName = name = (String)i$.next();
            if (((Object)globalNamespace).equals(namespaceHash.get(name))) {
                nameSpaceName = "<global>";
            }
            String[] macroNames = new String[((Map)namespaceHash.get(name)).size()];
            int i = 0;
            Iterator i$2 = ((Map)namespaceHash.get(name)).keySet().iterator();
            while (i$2.hasNext()) {
                String macroName;
                macroNames[i] = macroName = (String)i$2.next();
                ++i;
            }
            result.put(nameSpaceName, macroNames);
        }
        return result;
    }

    private Object getField(Object instance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }
}

