/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal.log;

import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;

public abstract class AbstractSLF4JLogChute
implements LogChute {
    protected abstract Logger getLogger();

    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message);
                break;
            }
            case 1: {
                this.getLogger().info(message);
                break;
            }
            case -1: {
                this.getLogger().trace(message);
                break;
            }
            case 3: {
                this.getLogger().error(message);
                break;
            }
            default: {
                this.getLogger().debug(message);
            }
        }
    }

    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.getLogger().warn(message, t);
                break;
            }
            case 1: {
                this.getLogger().info(message, t);
                break;
            }
            case -1: {
                this.getLogger().trace(message, t);
                break;
            }
            case 3: {
                this.getLogger().error(message, t);
                break;
            }
            default: {
                this.getLogger().debug(message, t);
            }
        }
    }

    public boolean isLevelEnabled(int level) {
        boolean islevelEnabled;
        switch (level) {
            case 0: {
                islevelEnabled = this.getLogger().isDebugEnabled();
                break;
            }
            case 1: {
                islevelEnabled = this.getLogger().isInfoEnabled();
                break;
            }
            case -1: {
                islevelEnabled = this.getLogger().isTraceEnabled();
                break;
            }
            case 2: {
                islevelEnabled = this.getLogger().isWarnEnabled();
                break;
            }
            case 3: {
                islevelEnabled = this.getLogger().isErrorEnabled();
                break;
            }
            default: {
                islevelEnabled = true;
            }
        }
        return islevelEnabled;
    }
}

