/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools;

import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONTool {
    private Logger logger = LoggerFactory.getLogger(JSONTool.class);

    public String serialize(Object object) {
        Object json = null;
        if (object == null) {
            json = JSONNull.getInstance();
        } else {
            if (object instanceof String) {
                return JSONUtils.valueToString((Object)object);
            }
            if (JSONUtils.isBoolean((Object)object)) {
                return object.toString();
            }
            if (JSONUtils.isNumber((Object)object)) {
                return JSONUtils.numberToString((Number)((Number)object));
            }
            json = JSONUtils.isArray((Object)object) ? JSONArray.fromObject((Object)object) : JSONObject.fromObject((Object)object);
        }
        return json.toString();
    }

    public JSON parse(String json) {
        try {
            return JSONSerializer.toJSON((Object)json);
        }
        catch (JSONException ex) {
            this.logger.info("Tried to parse invalid JSON: [{}], exception was: {}", (Object)StringUtils.abbreviate((String)json, (int)32), (Object)ex.getMessage());
            return null;
        }
    }
}

