/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextInitializer;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Named(value="velocity")
@Singleton
public class VelocityExecutionContextInitializer
implements ExecutionContextInitializer {
    public static final String VELOCITY_CONTEXT_ID = "velocityContext";
    @Inject
    private VelocityContextFactory velocityContextFactory;

    public void initialize(ExecutionContext executionContext) throws ExecutionContextException {
        try {
            if (!executionContext.hasProperty(VELOCITY_CONTEXT_ID)) {
                VelocityContext context = this.velocityContextFactory.createContext();
                executionContext.newProperty(VELOCITY_CONTEXT_ID).cloneValue().inherited().initial((Object)context).declare();
            }
        }
        catch (XWikiVelocityException e) {
            throw new ExecutionContextException("Failed to initialize Velocity Context", (Throwable)e);
        }
    }
}

