/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.tools.nio;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Map;
import org.xwiki.velocity.tools.nio.WrappingDirectoryStream;

public class NIOTool {
    public DirectoryStream<Path> newDirectoryStream(Path dir) {
        try {
            return new WrappingDirectoryStream(Files.newDirectoryStream(dir));
        }
        catch (IOException e) {
            return null;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter filter) {
        try {
            return new WrappingDirectoryStream(Files.newDirectoryStream(dir, filter));
        }
        catch (IOException e) {
            return null;
        }
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, String glob) {
        try {
            return new WrappingDirectoryStream(Files.newDirectoryStream(dir, glob));
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isDirectory(Path path, LinkOption ... options) {
        return Files.isDirectory(path, options);
    }

    public boolean isRegularFile(Path path, LinkOption ... options) {
        return Files.isRegularFile(path, options);
    }

    public boolean isReadable(Path path) {
        return Files.isReadable(path);
    }

    public boolean isSymbolicLink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public boolean exists(Path path, LinkOption ... options) {
        return Files.exists(path, options);
    }

    public byte[] readAllBytes(Path path) {
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    public List<String> readAllLines(Path path, Charset cs) {
        try {
            return Files.readAllLines(path, cs);
        }
        catch (IOException e) {
            return null;
        }
    }

    public BufferedReader newBufferedReader(Path path, Charset cs) {
        try {
            return Files.newBufferedReader(path, cs);
        }
        catch (IOException e) {
            return null;
        }
    }

    public long size(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public Object getAttribute(Path path, String attribute, LinkOption ... options) {
        try {
            return Files.getAttribute(path, attribute, options);
        }
        catch (IOException e) {
            return null;
        }
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) {
        try {
            return Files.readAttributes(path, attributes, options);
        }
        catch (IOException e) {
            return null;
        }
    }

    public FileTime getLastModifiedTime(Path path, LinkOption ... options) {
        try {
            return Files.getLastModifiedTime(path, options);
        }
        catch (IOException e) {
            return null;
        }
    }
}

