/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xml.internal.html.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xwiki.component.annotation.Component;
import org.xwiki.xml.html.filter.AbstractHTMLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="font")
public class FontFilter
extends AbstractHTMLFilter {
    private static final Map<String, String> FONT_SIZE_MAP = new HashMap<String, String>();

    @Override
    public void filter(Document document, Map<String, String> cleaningParameters) {
        List<Element> fontTags = this.filterDescendants(document.getDocumentElement(), new String[]{"font"});
        for (Element fontTag : fontTags) {
            Element span = document.createElement("span");
            this.moveChildren(fontTag, span);
            StringBuffer buffer = new StringBuffer();
            if (fontTag.hasAttribute("color")) {
                buffer.append(String.format("color:%s;", fontTag.getAttribute("color")));
            }
            if (fontTag.hasAttribute("face")) {
                buffer.append(String.format("font-family:%s;", fontTag.getAttribute("face")));
            }
            if (fontTag.hasAttribute("size")) {
                String fontSize = fontTag.getAttribute("size");
                String fontSizeCss = FONT_SIZE_MAP.get(fontSize);
                fontSizeCss = fontSizeCss != null ? fontSizeCss : fontSize;
                buffer.append(String.format("font-size:%s;", fontSizeCss));
            }
            if (fontTag.hasAttribute("style") && fontTag.getAttribute("style").trim().length() == 0) {
                buffer.append(fontTag.getAttribute("style"));
            }
            if (buffer.length() > 0) {
                span.setAttribute("style", buffer.toString());
            }
            fontTag.getParentNode().insertBefore(span, fontTag);
            fontTag.getParentNode().removeChild(fontTag);
        }
    }

    static {
        FONT_SIZE_MAP.put("1", "0.6em");
        FONT_SIZE_MAP.put("2", "0.8em");
        FONT_SIZE_MAP.put("3", "1.0em");
        FONT_SIZE_MAP.put("4", "1.2em");
        FONT_SIZE_MAP.put("5", "1.4em");
        FONT_SIZE_MAP.put("6", "1.6em");
        FONT_SIZE_MAP.put("7", "1.8em");
        FONT_SIZE_MAP.put("-3", "0.4em");
        FONT_SIZE_MAP.put("-2", FONT_SIZE_MAP.get("1"));
        FONT_SIZE_MAP.put("-1", FONT_SIZE_MAP.get("2"));
        FONT_SIZE_MAP.put("+1", FONT_SIZE_MAP.get("4"));
        FONT_SIZE_MAP.put("+2", FONT_SIZE_MAP.get("5"));
        FONT_SIZE_MAP.put("+3", FONT_SIZE_MAP.get("6"));
    }
}

