/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.xstream.internal;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Marker;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.xstream.internal.SafeMessageConverter;
import org.xwiki.xstream.internal.SafeXStream;
import org.xwiki.xstream.internal.XStreamUtils;

public class SafeLogEventConverter
extends SafeMessageConverter {
    protected static final String FIELD_LEVEL = "level";
    protected static final String FIELD_TIMESTAMP = "timeStamp";

    public SafeLogEventConverter(SafeXStream xstream) {
        super(xstream);
    }

    @Override
    public boolean canConvert(Class type) {
        return type == LogEvent.class;
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        LogEvent log = (LogEvent)source;
        XStreamUtils.serializeField(FIELD_LEVEL, LogLevel.class, log.getLevel(), writer, context, this.mapper());
        writer.startNode(FIELD_TIMESTAMP);
        writer.setValue(String.valueOf(log.getTimeStamp()));
        writer.endNode();
        super.marshal(source, writer, context);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        LogLevel level = null;
        Marker marker = null;
        String message = "";
        long timeStamp = -1L;
        List<Object> arguments = new ArrayList();
        Throwable throwable = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            switch (reader.getNodeName()) {
                case "level": {
                    level = this.read(LogLevel.class, reader, context);
                    break;
                }
                case "marker": {
                    marker = this.read(Marker.class, reader, context);
                    break;
                }
                case "message": {
                    message = reader.getValue();
                    break;
                }
                case "timeStamp": {
                    String timeStampString = reader.getValue();
                    timeStamp = NumberUtils.toLong((String)timeStampString, (long)-1L);
                    break;
                }
                case "throwable": {
                    throwable = this.read(Throwable.class, reader, context);
                    break;
                }
                case "argumentArray": {
                    arguments = this.unmarshalArgumentArray(reader, context);
                    break;
                }
            }
            reader.moveUp();
        }
        return new LogEvent(marker, level, message, arguments.toArray(), throwable, timeStamp);
    }
}

