/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.contrib.ratings.RatingsManager;

@Component
@Singleton
public class ConfiguredRatingsManagerProvider
implements Provider<RatingsManager> {
    @Inject
    Logger logger;
    @Inject
    Execution execution;
    @Inject
    ComponentManager componentManager;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    public RatingsManager get() {
        String ratingsHint = this.getXWiki().Param("xwiki.ratings.managerHint", "default");
        try {
            XWikiDocument configDoc = this.getXWiki().getDocument("XWiki.RatingsConfig", this.getXWikiContext());
            if (!configDoc.isNew() && configDoc.getObject("XWiki.RatingsConfigClass") != null) {
                BaseProperty prop = (BaseProperty)configDoc.getObject("XWiki.RatingsConfigClass").get("managerHint");
                String hint = prop == null ? null : (String)prop.getValue();
                ratingsHint = hint == null ? ratingsHint : hint;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot read ratings config", (Throwable)e);
        }
        try {
            return (RatingsManager)this.componentManager.getInstance(RatingsManager.class, ratingsHint);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error loading ratings manager component for hint " + ratingsHint, (Throwable)e);
            try {
                return (RatingsManager)this.componentManager.getInstance(RatingsManager.class, "default");
            }
            catch (ComponentLookupException e1) {
                return null;
            }
        }
    }
}

