/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseProperty;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.contrib.ratings.RatingsManager;
import org.xwiki.contrib.ratings.ReputationAlgorithm;
import org.xwiki.contrib.ratings.ReputationAlgorithmGroovy;

@Component
@Singleton
public class ConfiguredReputationAlgorithmProvider
implements Provider<ReputationAlgorithm> {
    @Inject
    Logger logger;
    @Inject
    Execution execution;
    @Inject
    ComponentManager componentManager;
    @Inject
    Provider<RatingsManager> ratingsManagerProvider;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    public ReputationAlgorithm get() {
        String reputationAlgorithmHint = this.getXWiki().Param("xwiki.ratings.managerHint", "default");
        try {
            XWikiDocument configDoc = this.getXWiki().getDocument("XWiki.RatingsConfig", this.getXWikiContext());
            if (configDoc != null && !configDoc.isNew() && configDoc.getObject("XWiki.RatingsConfigClass") != null) {
                BaseProperty prop = (BaseProperty)configDoc.getObject("XWiki.RatingsConfigClass").get("managerHint");
                String hint = prop == null ? null : (String)prop.getValue();
                reputationAlgorithmHint = hint == null ? reputationAlgorithmHint : hint;
            }
        }
        catch (Exception e) {
            this.logger.error("Cannot read reputation algorithm config", (Throwable)e);
        }
        if (reputationAlgorithmHint.contains(".")) {
            try {
                ReputationAlgorithmGroovy reputationInstance = (ReputationAlgorithmGroovy)this.getXWiki().parseGroovyFromPage(reputationAlgorithmHint, this.getXWikiContext());
                if (reputationInstance != null) {
                    reputationInstance.setComponentManager(this.componentManager);
                    reputationInstance.setExecution(this.execution);
                    reputationInstance.setXWikiContext(this.getXWikiContext());
                    reputationInstance.setRatingsManager((RatingsManager)this.ratingsManagerProvider.get());
                    return reputationInstance;
                }
            }
            catch (Throwable e) {
                this.logger.error("Cannot instanciate Reputation algorithm from page " + reputationAlgorithmHint, e);
            }
        }
        try {
            return (ReputationAlgorithm)this.componentManager.getInstance(ReputationAlgorithm.class, reputationAlgorithmHint);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error loading ratings manager component for hint " + reputationAlgorithmHint, (Throwable)e);
            try {
                return (ReputationAlgorithm)this.componentManager.getInstance(ReputationAlgorithm.class, "default");
            }
            catch (ComponentLookupException e1) {
                return null;
            }
        }
    }
}

