/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.context.Execution;
import org.xwiki.contrib.ratings.AverageRating;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;
import org.xwiki.contrib.ratings.RatingsManager;
import org.xwiki.contrib.ratings.ReputationException;
import org.xwiki.contrib.ratings.internal.MemoryAverageRating;
import org.xwiki.contrib.ratings.internal.StoredAverageRating;
import org.xwiki.observation.ObservationManager;

public abstract class AbstractRatingsManager
implements RatingsManager {
    @Inject
    Execution execution;
    @Inject
    ObservationManager observationManager;
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractRatingsManager.class);

    @Override
    public String getRatingsClassName() {
        return "XWiki.RatingsClass";
    }

    public String getAverageRatingsClassName() {
        return "XWiki.AverageRatingsClass";
    }

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    public boolean hasRatings() {
        int result = (int)this.getXWiki().ParamAsLong("xwiki.ratings", 0L);
        return this.getXWiki().getXWikiPreferenceAsInt("ratings", result, this.getXWikiContext()) == 1;
    }

    @Override
    public boolean isAverageRatingStored() {
        int result = (int)this.getXWiki().ParamAsLong("xwiki.ratings.averagerating.stored", 1L);
        return this.getXWiki().getXWikiPreferenceAsInt("ratings_averagerating_stored", result, this.getXWikiContext()) == 1;
    }

    @Override
    public boolean isReputationStored() {
        int result = (int)this.getXWiki().ParamAsLong("xwiki.ratings.reputation.stored", 0L);
        return this.getXWiki().getXWikiPreferenceAsInt("ratings_reputation_stored", result, this.getXWikiContext()) == 1;
    }

    @Override
    public boolean hasReputation() {
        int result = (int)this.getXWiki().ParamAsLong("xwiki.ratings.reputation", 0L);
        return this.getXWiki().getXWikiPreferenceAsInt("ratings_reputation", result, this.getXWikiContext()) == 1;
    }

    @Override
    public String[] getDefaultReputationMethods() {
        String method = this.getXWiki().Param("xwiki.ratings.reputation.defaultmethod", "average");
        method = this.getXWiki().getXWikiPreference("ratings_reputation_defaultmethod", method, this.getXWikiContext());
        return method.split(",");
    }

    @Override
    public void updateAverageRatings(String documentName, Rating rating, int oldVote) throws RatingsException {
        String[] methods = this.getDefaultReputationMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.updateAverageRating(documentName, rating, oldVote, methods[i]);
        }
    }

    @Override
    public AverageRating getAverageRatingFromQuery(String fromsql, String wheresql) throws RatingsException {
        return this.getAverageRatingFromQuery(fromsql, wheresql, "average");
    }

    @Override
    public AverageRating getAverageRating(String documentName) throws RatingsException {
        return this.getAverageRating(documentName, "average");
    }

    @Override
    public AverageRating getAverageRatingFromQuery(String fromsql, String wheresql, String method) throws RatingsException {
        try {
            String fromsql2 = fromsql + ", BaseObject as avgobj, FloatProperty as avgvote, StringProperty as avgmethod ";
            String wheresql2 = (wheresql.equals("") ? "where " : wheresql + " and ") + "doc.fullName=avgobj.name and avgobj.className='" + this.getAverageRatingsClassName() + "' and avgobj.id=avgvote.id.id and avgvote.id.name='" + "averagevote" + "' and avgobj.id=avgmethod.id.id and avgmethod.id.name='" + "method" + "' and avgmethod.value='" + method + "'";
            String sql = "select sum(avgvote.value) as vote, count(avgvote.value) as nbvotes from XWikiDocument as doc " + fromsql2 + wheresql2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Running average rating with sql " + sql);
            }
            this.getXWikiContext().put((Object)"lastsql", (Object)sql);
            List result = this.getXWiki().getStore().search(sql, 0, 0, this.getXWikiContext());
            float vote = ((Number)((Object[])result.get(0))[0]).floatValue();
            int nbvotes = ((Number)((Object[])result.get(0))[1]).intValue();
            MemoryAverageRating avgr = new MemoryAverageRating(null, nbvotes, vote / (float)nbvotes, method);
            return avgr;
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public boolean removeRating(Rating rating) throws RatingsException {
        return rating.remove();
    }

    @Override
    public AverageRating getUserReputation(String username) throws ReputationException {
        try {
            return this.getAverageRating(username, "average");
        }
        catch (RatingsException e) {
            throw new ReputationException(e);
        }
    }

    @Override
    public AverageRating calcAverageRating(String documentName, String method) throws RatingsException {
        int nbVotes = 0;
        int balancedNbVotes = 0;
        float totalVote = 0.0f;
        float averageVote = 0.0f;
        List<Rating> ratings = this.getRatings(documentName, 0, 0, true);
        if (ratings == null) {
            return null;
        }
        for (Rating rating : ratings) {
            if (method.equals("balanced")) {
                String author = rating.getAuthor();
                if (!author.equals(documentName)) {
                    AverageRating reputation = this.getUserReputation(author);
                    if (reputation == null || reputation.getAverageVote() == 0.0f) {
                        totalVote += (float)rating.getVote();
                        ++balancedNbVotes;
                    } else {
                        totalVote += (float)rating.getVote() * reputation.getAverageVote();
                        balancedNbVotes = (int)((float)balancedNbVotes + reputation.getAverageVote());
                    }
                }
            } else {
                totalVote += (float)rating.getVote();
                ++balancedNbVotes;
            }
            ++nbVotes;
        }
        if (balancedNbVotes != 0) {
            averageVote = totalVote / (float)balancedNbVotes;
        }
        return new MemoryAverageRating(documentName, nbVotes, averageVote, method);
    }

    @Override
    public void updateAverageRating(String documentName, Rating rating, int oldVote, String method) throws RatingsException {
        if (this.isAverageRatingStored() && oldVote != rating.getVote()) {
            AverageRating aRating = this.calcAverageRating(documentName, method);
            AverageRating averageRating = this.getAverageRating(documentName, method, true);
            averageRating.setAverageVote(aRating.getAverageVote());
            averageRating.setNbVotes(aRating.getNbVotes());
            averageRating.save();
        }
    }

    @Override
    public void updateUserReputation(String author, AverageRating voterRating) throws RatingsException {
        try {
            AverageRating rating = this.getAverageRating(author, voterRating.getMethod(), true);
            rating.setAverageVote(voterRating.getAverageVote());
            rating.setMethod(voterRating.getMethod());
            rating.setNbVotes(voterRating.getNbVotes());
            rating.save();
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public AverageRating getAverageRating(String documentName, String method) throws RatingsException {
        return this.getAverageRating(documentName, method, false);
    }

    @Override
    public AverageRating getAverageRating(String documentName, String method, boolean create) throws RatingsException {
        try {
            if (this.isAverageRatingStored()) {
                String className = this.getAverageRatingsClassName();
                XWikiDocument doc = this.getXWikiContext().getWiki().getDocument(documentName, this.getXWikiContext());
                BaseObject averageRatingObject = doc.getObject(className, "method", method, false);
                if (averageRatingObject == null) {
                    if (!create) {
                        return this.calcAverageRating(documentName, method);
                    }
                    averageRatingObject = doc.newObject(className, this.getXWikiContext());
                    averageRatingObject.setStringValue("method", method);
                }
                return new StoredAverageRating(doc, averageRatingObject, this.getXWikiContext());
            }
            return this.calcAverageRating(documentName, method);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }
}

