/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import java.util.Date;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;

public class DefaultRating
implements Rating {
    private String documentName;
    private XWikiDocument document;
    private BaseObject object;
    private XWikiContext context;

    public DefaultRating(String documentName, String author, int vote, XWikiContext context) {
        this(documentName, author, new Date(), vote, context);
    }

    public DefaultRating(String documentName, String author, Date date, int vote, XWikiContext context) {
        this.context = context;
        this.documentName = documentName;
        this.createObject(documentName, author, date, vote);
    }

    public DefaultRating(String documentName, BaseObject obj, XWikiContext context) {
        this.context = context;
        this.documentName = documentName;
        this.document = this.getDocument();
        this.object = obj;
    }

    @Override
    public String getRatingId() {
        return "" + this.object.getNumber();
    }

    @Override
    public String getGlobalRatingId() {
        return this.document.getFullName() + ":" + this.object.getNumber();
    }

    @Override
    public BaseObject getAsObject() {
        return this.object;
    }

    public XWikiDocument getDocument() {
        if (this.document == null) {
            try {
                this.document = this.context.getWiki().getDocument(this.documentName, this.context);
            }
            catch (XWikiException xWikiException) {
                // empty catch block
            }
        }
        return this.document;
    }

    @Override
    public String getAuthor() {
        return this.object.getStringValue("author");
    }

    @Override
    public void setAuthor(String author) {
        this.object.setStringValue("author", author);
    }

    @Override
    public Date getDate() {
        return this.object.getDateValue("date");
    }

    @Override
    public void setDate(Date date) {
        this.object.setDateValue("date", date);
    }

    @Override
    public int getVote() {
        return this.object.getIntValue("vote");
    }

    @Override
    public void setVote(int vote) {
        this.object.setIntValue("vote", vote);
    }

    @Override
    public Object get(String propertyName) {
        try {
            return ((BaseProperty)this.getAsObject().get(propertyName)).getValue();
        }
        catch (XWikiException e) {
            return null;
        }
    }

    @Override
    public String display(String propertyName, String mode) {
        return this.document.display(propertyName, mode, this.object, this.context);
    }

    @Override
    public String getDocumentName() {
        return this.documentName;
    }

    @Override
    public void save() throws RatingsException {
        try {
            this.getDocument().setContentDirty(false);
            this.context.getWiki().saveDocument(this.getDocument(), this.context);
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public boolean remove() {
        return this.remove(true);
    }

    protected boolean remove(boolean withSave) {
        try {
            XWikiDocument doc = this.getDocument();
            if (!doc.removeObject(this.object)) {
                return false;
            }
            if (withSave) {
                this.context.getWiki().saveDocument(doc, this.context);
            }
            return true;
        }
        catch (XWikiException e) {
            e.printStackTrace();
            return true;
        }
    }

    private void createObject(String documentName, String author, Date date, int vote) {
        XWikiDocument doc = this.getDocument();
        String ratingsClassName = "XWiki.RatingsClass";
        BaseObject obj = new BaseObject();
        obj.setClassName(ratingsClassName);
        obj.setName(doc.getFullName());
        obj.setStringValue("author", author);
        obj.setDateValue("date", date);
        obj.setIntValue("vote", vote);
        obj.setStringValue("parent", documentName);
        doc.addObject(ratingsClassName, obj);
        this.object = obj;
    }

    @Override
    public String toString() {
        boolean shouldAddSpace = false;
        StringBuffer sb = new StringBuffer();
        if (this.getAuthor() != null) {
            sb.append("\nAuthor=").append(this.getAuthor());
            shouldAddSpace = true;
        }
        if (this.getDate() != null) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nDate=").append(this.getDate());
            shouldAddSpace = true;
        }
        if (this.getVote() != -1) {
            sb.append(shouldAddSpace ? " " : "");
            sb.append("\nVote=").append(this.getVote()).append("\n");
            shouldAddSpace = true;
        }
        return sb.toString();
    }
}

