/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;
import org.xwiki.contrib.ratings.UpdateRatingEvent;
import org.xwiki.contrib.ratings.internal.AbstractRatingsManager;
import org.xwiki.contrib.ratings.internal.DefaultRating;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class DefaultRatingsManager
extends AbstractRatingsManager {
    @Inject
    private Logger LOGGER;

    @Override
    public Rating setRating(String documentName, String author, int vote) throws RatingsException {
        int oldVote;
        Rating rating = this.getRating(documentName, author);
        if (rating == null) {
            oldVote = 0;
            rating = new DefaultRating(documentName, author, vote, this.getXWikiContext());
        } else {
            oldVote = rating.getVote();
            rating.setVote(vote);
            rating.setDate(new Date());
        }
        rating.save();
        this.updateAverageRatings(documentName, rating, oldVote);
        this.observationManager.notify((Event)new UpdateRatingEvent(documentName, rating, oldVote), null);
        return rating;
    }

    @Override
    public List<Rating> getRatings(String documentName, int start, int count, boolean asc) throws RatingsException {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Calling default manager code for ratings");
        }
        try {
            int skipped = 0;
            int nb = 0;
            XWikiDocument doc = this.getXWiki().getDocument(documentName, this.getXWikiContext());
            Vector bobjects = doc.getObjects(this.getRatingsClassName());
            if (bobjects != null) {
                ArrayList<Rating> ratings = new ArrayList<Rating>();
                for (BaseObject bobj : bobjects) {
                    if (bobj == null) continue;
                    if (skipped < start) {
                        ++skipped;
                    } else {
                        ratings.add(this.getDefaultRating(documentName, bobj));
                        ++nb;
                    }
                    if (count == 0 || nb != count) continue;
                    break;
                }
                return ratings;
            }
        }
        catch (XWikiException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Rating getRating(String ratingId) throws RatingsException {
        try {
            int i1 = ratingId.indexOf(":");
            if (i1 == -1) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, cannot parse rating id");
            }
            String docName = ratingId.substring(0, i1);
            String sObjectNb = ratingId.substring(i1 + 1);
            int objectNb = Integer.parseInt(sObjectNb);
            XWikiDocument doc = this.getXWiki().getDocument(docName, this.getXWikiContext());
            if (doc.isNew()) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, document does not exist");
            }
            BaseObject object = doc.getObject(this.getRatingsClassName(), objectNb);
            if (object == null) {
                throw new RatingsException(1120, 1120004, "Invalid rating ID, could not find rating");
            }
            return new DefaultRating(docName, object, this.getXWikiContext());
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
    }

    @Override
    public Rating getRating(String documentName, int id) throws RatingsException {
        try {
            int skipped = 0;
            XWikiDocument doc = this.getXWiki().getDocument(documentName, this.getXWikiContext());
            Vector bobjects = doc.getObjects(this.getRatingsClassName());
            if (bobjects != null) {
                for (BaseObject bobj : bobjects) {
                    if (bobj == null) continue;
                    if (skipped < id) {
                        ++skipped;
                        continue;
                    }
                    return this.getDefaultRating(documentName, bobj);
                }
            }
        }
        catch (XWikiException e) {
            throw new RatingsException(e);
        }
        return null;
    }

    @Override
    public Rating getRating(String documentName, String author) throws RatingsException {
        try {
            if (author == null) {
                return null;
            }
            List<Rating> ratings = this.getRatings(documentName, 0, 0, false);
            if (ratings == null) {
                return null;
            }
            for (Rating rating : ratings) {
                if (rating == null || !author.equals(rating.getAuthor())) continue;
                return rating;
            }
        }
        catch (XWikiException e) {
            return null;
        }
        return null;
    }

    private DefaultRating getDefaultRating(String documentName, BaseObject bobj) {
        return new DefaultRating(documentName, bobj, this.getXWikiContext());
    }
}

