/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class DefaultRatingsManagerInitialization
implements EventListener,
Initializable {
    @Inject
    Logger logger;
    @Inject
    Execution execution;

    public List<Event> getEvents() {
        return Arrays.asList(new WikiReadyEvent());
    }

    public String getName() {
        return "ratingswikiinit";
    }

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    public void initialize() throws InitializationException {
        this.initRatingsClass();
        this.initAverageRatingsClass();
    }

    public void onEvent(Event wikiReadyEvent, Object arg1, Object arg2) {
        this.initRatingsClass();
        this.initAverageRatingsClass();
    }

    private void initAverageRatingsClass() {
        try {
            String content;
            XWiki xwiki = this.getXWiki();
            boolean needsUpdate = false;
            String averageRatingsClassName = "XWiki.AverageRatingsClass";
            XWikiDocument doc = xwiki.getDocument(averageRatingsClassName, this.getXWikiContext());
            BaseClass bclass = doc.getXClass();
            needsUpdate |= bclass.addNumberField("nbvotes", "Number of Votes", 5, "integer");
            needsUpdate |= bclass.addNumberField("averagevote", "Average Vote", 5, "float");
            needsUpdate |= bclass.addTextField("method", "Average Vote method", 10);
            if (StringUtils.isBlank((String)doc.getAuthor())) {
                needsUpdate = true;
                doc.setAuthor("xwiki:XWiki.Admin");
            }
            if (StringUtils.isBlank((String)doc.getCreator())) {
                needsUpdate = true;
                doc.setCreator("xwiki:XWiki.Admin");
            }
            if (StringUtils.isBlank((String)doc.getParent())) {
                needsUpdate = true;
                doc.setParent("XWiki.XWikiClasses");
            }
            if ((content = doc.getContent()) == null || content.equals("")) {
                needsUpdate = true;
                doc.setTitle("XWiki Average Ratings Class");
            }
            if (needsUpdate) {
                bclass.setName(averageRatingsClassName);
                xwiki.saveDocument(doc, this.getXWikiContext());
            }
        }
        catch (Exception e) {
            this.logger.error("Error while initializzing average ratings class", (Throwable)e);
        }
    }

    private void initRatingsClass() {
        try {
            String content;
            XWiki xwiki = this.getXWiki();
            boolean needsUpdate = false;
            String ratingsClassName = "XWiki.RatingsClass";
            XWikiDocument doc = xwiki.getDocument(ratingsClassName, this.getXWikiContext());
            BaseClass bclass = doc.getXClass();
            needsUpdate |= bclass.addTextField("author", "Author", 30);
            needsUpdate |= bclass.addNumberField("vote", "Vote", 5, "integer");
            needsUpdate |= bclass.addDateField("date", "Date");
            needsUpdate |= bclass.addTextField("parent", "Parent", 30);
            if (StringUtils.isBlank((String)doc.getAuthor())) {
                needsUpdate = true;
                doc.setAuthor("xwiki:XWiki.Admin");
            }
            if (StringUtils.isBlank((String)doc.getCreator())) {
                needsUpdate = true;
                doc.setCreator("xwiki:XWiki.Admin");
            }
            if (StringUtils.isBlank((String)doc.getParent())) {
                needsUpdate = true;
                doc.setParent("XWiki.XWikiClasses");
            }
            if ((content = doc.getContent()) == null || content.equals("")) {
                needsUpdate = true;
                doc.setTitle("XWiki Ratings Class");
            }
            if (needsUpdate) {
                bclass.setName(ratingsClassName);
                xwiki.saveDocument(doc, this.getXWikiContext());
            }
        }
        catch (Exception e) {
            this.logger.error("Error while initializzing ratings class", (Throwable)e);
        }
    }
}

