/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.contrib.ratings.AverageRating;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;
import org.xwiki.contrib.ratings.RatingsManager;
import org.xwiki.contrib.ratings.ReputationAlgorithm;
import org.xwiki.contrib.ratings.ReputationException;

@Component
@Singleton
public class DefaultReputationAlgorithm
implements ReputationAlgorithm {
    @Inject
    Logger LOGGER;
    @Inject
    Execution execution;
    @Inject
    Provider<RatingsManager> ratingsManagerProvider;

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    protected XWiki getXWiki() {
        return this.getXWikiContext().getWiki();
    }

    @Override
    public RatingsManager getRatingsManager() {
        return (RatingsManager)this.ratingsManagerProvider.get();
    }

    @Override
    public void updateReputation(String documentName, Rating rating, int oldVote) {
        block19: {
            if (oldVote != rating.getVote()) {
                block18: {
                    block17: {
                        try {
                            AverageRating voterRating = this.calcNewVoterReputation(rating.getAuthor(), documentName, rating, oldVote);
                            try {
                                this.getRatingsManager().updateUserReputation(rating.getAuthor(), voterRating);
                            }
                            catch (RatingsException re) {
                                if (this.LOGGER.isErrorEnabled()) {
                                    this.LOGGER.error("Error while storing reputation for user " + rating.getAuthor(), (Throwable)((Object)re));
                                }
                            }
                        }
                        catch (ReputationException e) {
                            if (e.getCode() == 1121001 || !this.LOGGER.isErrorEnabled()) break block17;
                            this.LOGGER.error("Error while calculating voter reputation " + rating.getAuthor() + " for document " + documentName, (Throwable)((Object)e));
                        }
                    }
                    try {
                        XWikiDocument doc = this.getXWiki().getDocument(documentName, this.getXWikiContext());
                        AverageRating authorRating = this.calcNewContributorReputation(doc.getCreator(), documentName, rating, oldVote);
                        try {
                            this.getRatingsManager().updateUserReputation(doc.getCreator(), authorRating);
                        }
                        catch (RatingsException re) {
                            if (this.LOGGER.isErrorEnabled()) {
                                this.LOGGER.error("Error while storing reputation for user " + doc.getCreator(), (Throwable)((Object)re));
                            }
                        }
                    }
                    catch (ReputationException e) {
                        if (e.getCode() != 1121001 && this.LOGGER.isErrorEnabled()) {
                            this.LOGGER.error("Error while calculating author reputation for document " + documentName, (Throwable)((Object)e));
                        }
                    }
                    catch (XWikiException e) {
                        if (!this.LOGGER.isErrorEnabled()) break block18;
                        this.LOGGER.error("Error while calculating author reputation for document " + documentName, (Throwable)e);
                    }
                }
                try {
                    Map<String, AverageRating> authorsRatings = this.calcNewAuthorsReputation(documentName, rating, oldVote);
                }
                catch (ReputationException e) {
                    if (e.getCode() != 1121001 && this.LOGGER.isErrorEnabled()) {
                        this.LOGGER.error("Error while calculating authors reputation for document " + documentName, (Throwable)((Object)e));
                    }
                }
                catch (XWikiException e) {
                    if (!this.LOGGER.isErrorEnabled()) break block19;
                    this.LOGGER.error("Error while calculating authors for document " + documentName, (Throwable)e);
                }
            }
        }
    }

    @Override
    public AverageRating calcNewVoterReputation(String voter, String documentName, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public AverageRating calcNewContributorReputation(String contributor, String documentName, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public Map<String, AverageRating> calcNewAuthorsReputation(String documentName, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public Map<String, AverageRating> recalcAllReputation() throws ReputationException {
        this.notimplemented();
        return null;
    }

    protected void notimplemented() throws ReputationException {
        throw new ReputationException(1121, 1121001, "Not implemented");
    }
}

