/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.ratings.internal;

import com.xpn.xwiki.XWikiException;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.ratings.AverageRating;
import org.xwiki.contrib.ratings.Rating;
import org.xwiki.contrib.ratings.RatingsException;
import org.xwiki.contrib.ratings.ReputationException;
import org.xwiki.contrib.ratings.internal.DefaultReputationAlgorithm;

@Component
@Singleton
@Named(value="simple")
public class SimpleReputationAlgorithm
extends DefaultReputationAlgorithm {
    protected float totalReputation;
    protected float constantX = -2.0f;
    protected float constantY = 50.0f;

    public AverageRating getUserReputation(String username) throws ReputationException {
        try {
            AverageRating aveRating = this.getRatingsManager().getAverageRating(username, "average");
            float oldRep = aveRating.getAverageVote();
            aveRating.setAverageVote(aveRating.getAverageVote() * 100.0f / this.getTotalReputation());
            this.totalReputation += aveRating.getAverageVote() - oldRep;
            return aveRating;
        }
        catch (RatingsException e) {
            throw new ReputationException(e);
        }
    }

    @Override
    public AverageRating calcNewVoterReputation(String voter, String documentName, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public AverageRating calcNewContributorReputation(String contributor, String documentName, Rating rating, int oldVote) throws ReputationException {
        String voter = rating.getAuthor();
        float voterRep = this.getUserReputation(voter).getAverageVote();
        float constantX = this.getConstantX();
        float constantY = this.getConstantY();
        AverageRating currentRep = this.getUserReputation(contributor);
        currentRep.setAverageVote(currentRep.getAverageVote() + ((float)rating.getVote() + constantX) * voterRep / constantY);
        this.notimplemented();
        return null;
    }

    private float getTotalReputation() {
        if (this.totalReputation == 0.0f) {
            try {
                List result = this.getXWiki().search("select sum(prop.value) from XWikiDocument as doc, BaseObject as obj, FloatProperty as prop where doc.fullName=obj.name and obj.className='XWiki.XWikiUsers' and obj.id=prop.id.id and prop.id.name='averagevote'", this.getXWikiContext());
                this.totalReputation = result == null || result.size() == 0 ? 0.0f : ((Float)result.get(0)).floatValue();
            }
            catch (XWikiException e) {
                this.totalReputation = 0.0f;
            }
        }
        return this.totalReputation <= 1.0f ? 1.0f : this.totalReputation;
    }

    private float getConstantX() {
        return this.constantX;
    }

    private float getConstantY() {
        return this.constantY;
    }

    @Override
    public Map<String, AverageRating> calcNewAuthorsReputation(String documentName, Rating rating, int oldVote) throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    public Map<String, AverageRating> recalcAllReputation() throws ReputationException {
        this.notimplemented();
        return null;
    }

    @Override
    protected void notimplemented() throws ReputationException {
        throw new ReputationException(1121, 1121001, "Not implemented");
    }
}

