/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.social.authentication.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.social.authentication.SocialAuthConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultSocialAuthConfiguration
implements SocialAuthConfiguration {
    private static final String PREFIX = "socialauth.";
    @Inject
    @Named(value="socialAuth")
    private ConfigurationSource configuration;

    @Override
    public List<String> getAvailableProviders() {
        return Arrays.asList(((String)this.configuration.getProperty("socialauth.availableProviders", (Object)"")).split("[,\n]"));
    }

    @Override
    public boolean getLoginButtonsEnabled() {
        Object value = this.configuration.getProperty("socialauth.loginButtonsEnabled", (Object)"1");
        try {
            return (Integer)value > 0;
        }
        catch (ClassCastException e) {
            try {
                return (Boolean)value;
            }
            catch (ClassCastException e2) {
                return false;
            }
        }
    }

    @Override
    public boolean isAutomaticUserCreation() {
        Object value = this.configuration.getProperty("socialauth.automaticUserCreation", (Object)"1");
        try {
            return (Integer)value > 0;
        }
        catch (ClassCastException e) {
            try {
                return (Boolean)value;
            }
            catch (ClassCastException e2) {
                return false;
            }
        }
    }

    @Override
    public String getDomainRestriction() {
        return (String)this.configuration.getProperty("socialauth.domainRestriction", (Object)"");
    }
}

