/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.social.authentication.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.web.XWikiRequest;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.SocialAuthConfig;
import org.brickred.socialauth.SocialAuthManager;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.crypto.passwd.PasswordCryptoService;
import org.xwiki.environment.Environment;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.social.authentication.ProfilePictureProviderTransformer;
import org.xwiki.social.authentication.SocialAuthConfiguration;
import org.xwiki.social.authentication.SocialAuthConstants;
import org.xwiki.social.authentication.SocialAuthException;
import org.xwiki.social.authentication.SocialAuthSession;
import org.xwiki.social.authentication.SocialAuthenticationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class DefaultSocialAuthManager
implements SocialAuthenticationManager,
SocialAuthConstants {
    private static final String DEFAULT_PROFILE_PICTURE_FILENAME = "profile.jpg";
    private static final String GLOBAL_CONFIGURATION_KEY = "xwiki.authentication.socialLogin.globalConfiguration";
    private static final String EXTRA_REGISTRATION_STEP_DOCUMENT = "XWiki.SocialLoginRegister";
    @Inject
    private Logger logger;
    @Inject
    private Environment environment;
    @Inject
    private Execution execution;
    @Inject
    private QueryManager queryManager;
    @Inject
    private SocialAuthConfiguration configuration;
    @Inject
    private PasswordCryptoService passwordCryptoService;
    @Inject
    private Map<String, ProfilePictureProviderTransformer> profilePictureTransformers;
    @Inject
    private EntityReferenceValueProvider valueProvider;
    private SocialAuthConfig config;

    @Override
    public void associateAccount(String providerId) throws SocialAuthException {
        XWikiContext context = this.getContext();
        XWikiRequest request = context.getRequest();
        try {
            if (StringUtils.isBlank((CharSequence)request.getParameter("sl_callback"))) {
                String url = request.getRequestURL() + "?" + request.getQueryString() + "&" + "sl_callback" + "=1&" + "sl_provider" + "=" + providerId;
                this.requestConnection(providerId, url);
            } else {
                SocialAuthSession session = (SocialAuthSession)request.getSession().getAttribute("org.xwiki.social.authentication.SocialAuthSession");
                AuthProvider provider = session.getAuthManager().connect(SocialAuthUtil.getRequestParametersMap((HttpServletRequest)request));
                session.putAuthProvider(providerId, provider);
                Profile profile = provider.getUserProfile();
                if (this.getUser(providerId, profile.getValidatedId()) != null) {
                    throw new SocialAuthException("Refusing to associate account as it is already associated with a user on this wiki.");
                }
                this.addSocialProfileToUser(profile, this.getContext().getUserReference());
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to associate account", e);
        }
    }

    @Override
    public void ensureConnected(String providerId) throws SocialAuthException {
        XWikiContext context = this.getContext();
        XWikiRequest request = context.getRequest();
        try {
            if (StringUtils.isBlank((CharSequence)request.getParameter("sl_callback"))) {
                String url = request.getRequestURL() + "?" + (String)StringUtils.defaultIfBlank((CharSequence)request.getQueryString(), (CharSequence)"") + "&" + "sl_callback" + "=1&" + "sl_provider" + "=" + providerId;
                this.requestConnection(providerId, url);
            } else {
                SocialAuthSession session = (SocialAuthSession)request.getSession().getAttribute("org.xwiki.social.authentication.SocialAuthSession");
                AuthProvider provider = session.getAuthManager().connect(SocialAuthUtil.getRequestParametersMap((HttpServletRequest)request));
                session.putAuthProvider(providerId, provider);
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to associate account", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DocumentReference connect(Map<String, String> requestParameters) throws SocialAuthException {
        SocialAuthSession session = this.getSession();
        try {
            SocialAuthManager manager = session.getAuthManager();
            AuthProvider provider = manager.connect(requestParameters);
            Profile profile = provider.getUserProfile();
            String domainRestriction = this.configuration.getDomainRestriction();
            if (!(StringUtils.isBlank((CharSequence)domainRestriction) || !StringUtils.isBlank((CharSequence)profile.getEmail()) && profile.getEmail().endsWith(domainRestriction))) {
                XWikiContext context2 = this.getContext();
                context2.put((Object)"message", (Object)"xwiki.socialLogin.unauthorizedDomainError");
                throw new SocialAuthException("Failed to validate connection because email is not matching the authorized domain");
            }
            boolean isGlobalConfiguration = this.isGlobalConfiguration();
            XWikiContext context = this.getContext();
            String currentDatabase = context.getDatabase();
            if (isGlobalConfiguration) {
                context.setDatabase(this.getMainWikiName());
            }
            try {
                DocumentReference user = this.getUser(profile.getProviderId(), profile.getValidatedId());
                String key = this.getEncryptionKey();
                session.putAuthProvider(profile.getProviderId(), provider);
                session.setCurrentProvider(profile.getProviderId());
                if (user == null) {
                    if (!this.configuration.isAutomaticUserCreation()) {
                        this.getResponse().sendRedirect(context.getWiki().getURL(EXTRA_REGISTRATION_STEP_DOCUMENT, "view", context));
                        DocumentReference documentReference2 = null;
                        return documentReference2;
                    }
                    user = this.createUser(profile, this.computeUsername(profile));
                }
                XWikiDocument userDocument = this.getContext().getWiki().getDocument(user, this.getContext());
                BaseObject object = userDocument.getObject("XWiki.SocialLoginProfileClass", "provider", profile.getProviderId());
                String password = object.getStringValue("password");
                this.setPassword(password);
                DocumentReference documentReference = user;
                return documentReference;
            }
            finally {
                if (isGlobalConfiguration) {
                    context.setDatabase(currentDatabase);
                }
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to validate connection", e);
        }
    }

    @Override
    public DocumentReference createUser(Map<String, String> extraProperties) throws XWikiException, SocialAuthException {
        SocialAuthSession session = this.getSession();
        if (session == null || session.getProfile() == null) {
            throw new SocialAuthException("Illegal attempt at creating a user that is not associated");
        }
        return this.createUser(this.computeUsername(session.getProfile()), extraProperties);
    }

    @Override
    public DocumentReference createUser(String username, Map<String, String> extraProperties) throws XWikiException, SocialAuthException {
        SocialAuthSession session = this.getSession();
        if (session == null || session.getProfile() == null) {
            throw new SocialAuthException("Illegal attempt at creating a user that is not associated");
        }
        return this.createUser(session.getProfile(), username, extraProperties);
    }

    @Override
    public SocialAuthSession getSession() {
        HttpSession httpSession = this.getRequest().getSession();
        SocialAuthSession session = (SocialAuthSession)httpSession.getAttribute("org.xwiki.social.authentication.SocialAuthSession");
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentReference getUser(String provider, String id) {
        DocumentReference documentReference;
        boolean isGlobalConfiguration = this.isGlobalConfiguration();
        XWikiContext context = this.getContext();
        String currentDatabase = context.getDatabase();
        if (isGlobalConfiguration) {
            context.setDatabase(this.getMainWikiName());
        }
        try {
            String queryStatement = "from doc.object(XWiki.XWikiUsers) as user, doc.object(XWiki.SocialLoginProfileClass) as profile where profile.provider = :provider and profile.validatedId = :validated";
            Query query = this.queryManager.createQuery(queryStatement, "xwql");
            query.bindValue("provider", (Object)provider);
            query.bindValue("validated", (Object)id);
            List results = query.execute();
            Iterator i$ = results.iterator();
            if (i$.hasNext()) {
                String reference = (String)i$.next();
                DocumentReference documentReference2 = this.getContext().getWiki().getDocument(reference, this.getContext()).getDocumentReference();
                return documentReference2;
            }
            DocumentReference documentReference3 = null;
            return documentReference3;
        }
        catch (QueryException e) {
            this.logger.error("Failed to query for user with provider [{}] and id [{}]", (Object)provider, (Object)id);
            documentReference = null;
            return documentReference;
        }
        catch (XWikiException e) {
            this.logger.error("Failed to query for user with provider [{}] and id [{}]", (Object)provider, (Object)id);
            documentReference = null;
            return documentReference;
        }
        finally {
            if (isGlobalConfiguration) {
                context.setDatabase(currentDatabase);
            }
        }
    }

    @Override
    public boolean hasProvider(DocumentReference user, String provider) {
        try {
            XWikiDocument userDocument = this.getContext().getWiki().getDocument(user, this.getContext());
            BaseObject object = userDocument.getObject("XWiki.SocialLoginProfileClass", "provider", provider);
            return object != null;
        }
        catch (XWikiException e) {
            this.logger.error(MessageFormat.format("Failed to determine if user [{0}] has associated provider [{1}]", user, provider), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected(this.getSession());
    }

    @Override
    public boolean isConnected(String provider) {
        return this.isConnected(this.getSession(), provider);
    }

    @Override
    public void requestConnection(String provider, String returnUrl) throws SocialAuthException {
        HttpSession httpSession = this.getRequest().getSession();
        HttpServletResponse response = this.getResponse();
        try {
            SocialAuthManager manager = new SocialAuthManager();
            manager.setSocialAuthConfig(this.getSocialAuthConfig());
            SocialAuthSession session = new SocialAuthSession(manager);
            httpSession.setAttribute("org.xwiki.social.authentication.SocialAuthSession", (Object)session);
            String url = manager.getAuthenticationUrl(provider, returnUrl);
            this.logger.debug("Redirecting to OAuth endpoint URL : " + url);
            try {
                response.sendRedirect(url);
            }
            catch (IllegalStateException e) {}
        }
        catch (Exception e) {
            throw new SocialAuthException("Error when requesting connection", e);
        }
    }

    @Override
    public boolean userExists(String provider, String id) {
        return this.getUser(provider, id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSocialProfileToUser(Profile profile, DocumentReference user) throws SocialAuthException {
        boolean isGlobalConfiguration = this.isGlobalConfiguration();
        XWikiContext context = this.getContext();
        String currentDatabase = context.getDatabase();
        if (isGlobalConfiguration) {
            context.setDatabase(this.getMainWikiName());
        }
        try {
            XWikiDocument userDoc = context.getWiki().getDocument(user, context);
            String generatedPassword = this.getContext().getWiki().generateRandomString(16);
            BaseObject socialProfile = userDoc.getObject("XWiki.SocialLoginProfileClass", true, context);
            BaseObject userObject = userDoc.getObject("XWiki.XWikiUsers", false, context);
            if (userObject == null) {
                throw new SocialAuthException("Cannot associate a social profile to a non-user page");
            }
            if (StringUtils.isBlank((CharSequence)userObject.getStringValue("first_name"))) {
                userObject.set("first_name", (Object)profile.getFirstName(), context);
            }
            if (StringUtils.isBlank((CharSequence)userObject.getStringValue("last_name"))) {
                userObject.set("last_name", (Object)profile.getLastName(), context);
            }
            if (StringUtils.isBlank((CharSequence)userObject.getStringValue("email"))) {
                userObject.set("email", (Object)profile.getEmail(), context);
            }
            if (!StringUtils.isBlank((CharSequence)profile.getProfileImageURL()) && StringUtils.isBlank((CharSequence)userObject.getStringValue("avatar"))) {
                String profilePictureURL = profile.getProfileImageURL();
                if (this.profilePictureTransformers.containsKey(profile.getProviderId())) {
                    profilePictureURL = this.profilePictureTransformers.get(profile.getProviderId()).transform(profilePictureURL);
                }
                GetMethod get = new GetMethod(profilePictureURL);
                try {
                    XWikiAttachment attachment = new XWikiAttachment(userDoc, DEFAULT_PROFILE_PICTURE_FILENAME);
                    userDoc.getAttachmentList().add(attachment);
                    HttpClient httpClient = new HttpClient();
                    httpClient.getParams().setBooleanParameter("http.connection.stalecheck", true);
                    int httpStatus = httpClient.executeMethod((HttpMethod)get);
                    if (httpStatus == 200) {
                        attachment.setContent(get.getResponseBodyAsStream());
                        attachment.setAuthor(userDoc.getAuthor());
                        attachment.setDoc(userDoc);
                        userObject.set("avatar", (Object)DEFAULT_PROFILE_PICTURE_FILENAME, context);
                    } else {
                        this.logger.debug("Failed to load image: status is " + httpStatus);
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Error attaching social profile picture to profile", (Throwable)e);
                }
                finally {
                    get.releaseConnection();
                }
            }
            socialProfile.set("provider", (Object)profile.getProviderId(), context);
            socialProfile.set("fullName", (Object)profile.getFullName(), context);
            socialProfile.set("firstName", (Object)profile.getFirstName(), context);
            socialProfile.set("lastName", (Object)profile.getLastName(), context);
            socialProfile.set("displayName", (Object)profile.getDisplayName(), context);
            socialProfile.set("email", (Object)profile.getEmail(), context);
            socialProfile.set("profileImageURL", (Object)profile.getProfileImageURL(), context);
            socialProfile.set("gender", (Object)profile.getGender(), context);
            if (profile.getDob() != null) {
                socialProfile.set("dob", (Object)profile.getDob().toString(), context);
            }
            socialProfile.set("validatedId", (Object)profile.getValidatedId(), context);
            socialProfile.set("country", (Object)profile.getCountry(), context);
            socialProfile.set("location", (Object)profile.getLocation(), context);
            socialProfile.set("password", (Object)generatedPassword, context);
            this.setPassword(generatedPassword);
            context.getWiki().saveDocument(userDoc, context.getMessageTool().get("xwiki.socialLogin.updatedSocialProfile"), true, context);
        }
        catch (XWikiException e) {
            this.logger.error("Failed to merge or create user", (Throwable)e);
        }
        finally {
            if (isGlobalConfiguration) {
                context.setDatabase(currentDatabase);
            }
        }
    }

    private String computeUsername(Profile profile) {
        String username = profile.getDisplayName();
        if (StringUtils.isBlank((CharSequence)username)) {
            username = profile.getFirstName() + profile.getLastName();
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            username = profile.getProviderId() + "-" + profile.getValidatedId();
        }
        return this.getContext().getWiki().getUniquePageName("XWiki", username, this.getContext());
    }

    private DocumentReference createUser(Profile profile, String username) throws XWikiException, SocialAuthException {
        return this.createUser(profile, username, Collections.<String, String>emptyMap());
    }

    private DocumentReference createUser(Profile profile, String username, Map<String, String> extraProperties) throws XWikiException, SocialAuthException {
        String userDocumentName = "XWiki." + username;
        if (this.isGlobalConfiguration()) {
            userDocumentName = this.getMainWikiName() + ":" + userDocumentName;
        }
        XWikiContext context = this.getContext();
        HashMap<String, String> properties = new HashMap<String, String>(extraProperties);
        properties.put("active", "1");
        properties.put("email", profile.getEmail());
        properties.put("first_name", profile.getFirstName());
        properties.put("last_name", profile.getLastName());
        properties.put("password", this.getContext().getWiki().generateRandomString(16));
        context.getWiki().createUser(username, properties, context);
        XWikiDocument userDoc = context.getWiki().getDocument(userDocumentName, context);
        this.addSocialProfileToUser(profile, userDoc.getDocumentReference());
        return userDoc.getDocumentReference();
    }

    private XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private String getEncryptionKey() {
        String key = this.getContext().getWiki().Param("xwiki.authentication.encryptionKey");
        return key;
    }

    private String getMainWikiName() {
        return this.valueProvider.getDefaultValue(EntityType.WIKI);
    }

    private HttpServletRequest getRequest() {
        return this.getContext().getRequest();
    }

    private HttpServletResponse getResponse() {
        return this.getContext().getResponse();
    }

    private boolean isGlobalConfiguration() {
        return "1".equals(this.getContext().getWiki().Param(GLOBAL_CONFIGURATION_KEY));
    }

    private SocialAuthConfig getSocialAuthConfig() {
        if (this.config == null) {
            try {
                Properties properties = new Properties();
                properties.load(this.environment.getResourceAsStream("/WEB-INF/oauth_consumer.properties"));
                this.config = SocialAuthConfig.getDefault();
                this.config.load(properties);
            }
            catch (Exception e) {
                this.logger.error("Failed to initialize Social Auth", (Throwable)e);
            }
        }
        return this.config;
    }

    private boolean isConnected(SocialAuthSession profile) {
        return profile != null && this.isConnected(profile, profile.getCurrentProvider());
    }

    private boolean isConnected(SocialAuthSession profile, String provider) {
        return profile != null && profile.getProfile(provider) != null;
    }

    private void setPassword(String password) {
        try {
            this.getSession().setEncryptedPassword(this.passwordCryptoService.encryptText(password, this.getEncryptionKey()));
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
    }
}

