/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Manifest;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class JarOutputStream
extends ZipOutputStream {
    private static final int JAR_MAGIC = 51966;
    private boolean firstEntry = true;
    private boolean preventClose = false;

    public JarOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public JarOutputStream(File file, Manifest manifest) throws IOException {
        super(file);
        if (manifest == null) {
            throw new NullPointerException("man");
        }
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        this.putNextEntry(zipEntry);
        manifest.write(new BufferedOutputStream((OutputStream)((Object)this)));
        this.closeEntry();
    }

    public JarOutputStream(File file) throws IOException {
        super(file);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.firstEntry) {
            byte[] byArray = zipEntry.getExtra();
            if (byArray != null && !JarOutputStream.hasMagic(byArray)) {
                byte[] byArray2 = new byte[byArray.length + 4];
                System.arraycopy(byArray2, 4, byArray, 0, byArray.length);
                byArray = byArray2;
            } else {
                byArray = new byte[4];
            }
            JarOutputStream.set16(byArray, 0, 51966);
            JarOutputStream.set16(byArray, 2, 0);
            zipEntry.setExtra(byArray);
            this.firstEntry = false;
        }
        super.putNextEntry(zipEntry);
    }

    public boolean isPreventClose() {
        return this.preventClose;
    }

    public void setPreventClose(boolean bl) {
        this.preventClose = bl;
    }

    public void close() throws IOException {
        if (!this.isPreventClose()) {
            super.close();
        }
    }

    public void closeAlways() throws IOException {
        this.setPreventClose(false);
        this.close();
    }

    private static boolean hasMagic(byte[] byArray) {
        try {
            for (int i = 0; i < byArray.length; i += JarOutputStream.get16(byArray, i + 2) + 4) {
                if (JarOutputStream.get16(byArray, i) != 51966) continue;
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    private static int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static void set16(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
        byArray[n + 1] = (byte)(n2 >> 8);
    }
}

