/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.escaping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.xwiki.test.escaping.framework.AbstractEscapingTest;
import org.xwiki.test.escaping.framework.AbstractVelocityEscapingTest;
import org.xwiki.test.escaping.framework.EscapingError;
import org.xwiki.test.escaping.framework.SingleXWikiExecutor;
import org.xwiki.test.escaping.framework.XMLEscapingValidator;
import org.xwiki.test.escaping.suite.ArchiveSuite;
import org.xwiki.validator.ValidationError;

@RunWith(value=ArchiveSuite.class)
public class ApplicationTest
extends AbstractVelocityEscapingTest {
    @ArchiveSuite.ArchivePathGetter
    public static String getArchivePath() {
        return System.getProperty("localRepository") + "/" + System.getProperty("pathToXWikiXar");
    }

    @ArchiveSuite.BeforeSuite
    public static void init() throws Exception {
        SingleXWikiExecutor.getExecutor().start();
        AbstractEscapingTest.setMultiLanguageMode(true);
    }

    @ArchiveSuite.AfterSuite
    public static void shutdown() throws Exception {
        AbstractEscapingTest.setMultiLanguageMode(false);
        SingleXWikiExecutor.getExecutor().stop();
    }

    public ApplicationTest() {
        super(Pattern.compile(".+/.+\\.xml"));
    }

    @Test
    public void testParametersInColibri() {
        this.testParameterEscaping("colibri");
    }

    private void testParameterEscaping(String skin) {
        Assume.assumeTrue((!this.userInput.isEmpty() ? 1 : 0) != 0);
        String space = this.name.replaceAll("/.+$", "");
        String page = this.name.replaceAll("^.+/", "").replaceAll("\\..+$", "");
        ArrayList<EscapingError> errors = new ArrayList<EscapingError>();
        for (String parameter : this.userInput) {
            String url = this.createUrl(space, page, parameter, XMLEscapingValidator.getTestString(), skin);
            List<ValidationError> val_errors = this.getUnderEscapingErrors(url);
            if (val_errors.isEmpty()) continue;
            errors.add(new EscapingError("* Parameter: \"" + parameter + "\"", this.name, url, val_errors));
        }
        if (!errors.isEmpty()) {
            throw new EscapingError("Escaping test failed.", errors);
        }
    }

    protected String createUrl(String space, String page, String parameter, String value, String skin) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (skin != null) {
            parameters.put("skin", skin);
        }
        if (parameter != null) {
            parameters.put(parameter, value);
        }
        return ApplicationTest.createUrl(null, space, page, parameters);
    }
}

