/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.resources.attachments.AttachmentHistoryResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentsAtPageVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class AttachmentsResourceTest
extends AbstractHttpTest {
    private final String SPACE_NAME = "Main";
    private final String PAGE_NAME = "WebHome";

    public void testRepresentation() throws Exception {
    }

    public void testPUTAttachment() throws Exception {
        String attachmentName = String.format("%s.txt", UUID.randomUUID());
        String content = "ATTACHMENT CONTENT";
        String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        GetMethod getMethod = this.executeGet(attachmentUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
        PutMethod putMethod = this.executePut(attachmentUri, content, "text/plain", "Admin", "admin");
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
        getMethod = this.executeGet(attachmentUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        AttachmentsResourceTest.assertEquals((String)content, (String)getMethod.getResponseBodyAsString());
    }

    public void testPUTAttachmentNoRights() throws Exception {
        String attachmentName = String.format("%s.txt", UUID.randomUUID());
        String content = "ATTACHMENT CONTENT";
        String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        GetMethod getMethod = this.executeGet(attachmentUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
        PutMethod putMethod = this.executePut(attachmentUri, content, "text/plain");
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)401, (int)putMethod.getStatusCode());
    }

    public void testGETAttachments() throws Exception {
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        AttachmentsResourceTest.assertTrue((attachments.getAttachments().size() > 0 ? 1 : 0) != 0);
    }

    public void testDELETEAttachment() throws Exception {
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        AttachmentsResourceTest.assertTrue((attachments.getAttachments().size() > 0 ? 1 : 0) != 0);
        String attachmentName = ((Attachment)attachments.getAttachments().get(0)).getName();
        String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        DeleteMethod deleteMethod = this.executeDelete(attachmentUri, "Admin", "admin");
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (int)204, (int)deleteMethod.getStatusCode());
        getMethod = this.executeGet(attachmentUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
    }

    public void testDELETEAttachmentNoRights() throws Exception {
        String attachmentName = String.format("%d.txt", System.currentTimeMillis());
        String content = "ATTACHMENT CONTENT";
        String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        PutMethod putMethod = this.executePut(attachmentUri, content, "text/plain", "Admin", "admin");
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
        DeleteMethod deleteMethod = this.executeDelete(attachmentUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (int)401, (int)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(attachmentUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
    }

    public void testGETAttachmentsAtPageVersion() throws Exception {
        int i;
        int NUMBER_OF_ATTACHMENTS = 4;
        String[] attachmentNames = new String[4];
        String[] pageVersions = new String[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            attachmentNames[i2] = String.format("%s.txt", UUID.randomUUID());
        }
        String content = "ATTACHMENT CONTENT";
        for (i = 0; i < 4; ++i) {
            String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentNames[i]}).toString();
            PutMethod putMethod = this.executePut(attachmentUri, content, "text/plain", "Admin", "admin");
            AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
            Attachment attachment = (Attachment)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
            pageVersions[i] = attachment.getPageVersion();
        }
        for (i = 0; i < 4; ++i) {
            String attachmentsUri = this.getUriBuilder(AttachmentsAtPageVersionResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", pageVersions[i]}).toString();
            GetMethod getMethod = this.executeGet(attachmentsUri);
            AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            for (int j = 0; j <= i; ++j) {
                boolean found = false;
                for (Attachment attachment : attachments.getAttachments()) {
                    if (!attachment.getName().equals(attachmentNames[j]) || !attachment.getPageVersion().equals(pageVersions[i])) continue;
                    found = true;
                    break;
                }
                AttachmentsResourceTest.assertTrue((String)String.format("%s is not present in attachments list of the page at version %s", attachmentNames[j], pageVersions[i]), (boolean)found);
            }
            for (Attachment attachment : attachments.getAttachments()) {
                this.checkLinks((LinkCollection)attachment);
            }
        }
    }

    public void testGETAttachmentVersions() throws Exception {
        int NUMBER_OF_VERSIONS = 4;
        String attachmentName = String.format("%s.txt", UUID.randomUUID().toString());
        HashMap<String, String> versionToContentMap = new HashMap<String, String>();
        for (int i = 0; i < 4; ++i) {
            String attachmentUri = this.getUriBuilder(AttachmentResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
            String content = String.format("CONTENT %d", i);
            PutMethod putMethod = this.executePut(attachmentUri, content, "text/plain", "Admin", "admin");
            if (i == 0) {
                AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
            } else {
                AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
            }
            Attachment attachment = (Attachment)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
            versionToContentMap.put(attachment.getVersion(), content);
        }
        String attachmentsUri = this.getUriBuilder(AttachmentHistoryResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        GetMethod getMethod = this.executeGet(attachmentsUri);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (Attachment attachment : attachments.getAttachments()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)attachment, "http://www.xwiki.org/rel/attachmentData").getHref());
            AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            AttachmentsResourceTest.assertEquals((String)((String)versionToContentMap.get(attachment.getVersion())), (String)getMethod.getResponseBodyAsString());
        }
    }

    public void testPOSTAttachment() throws Exception {
        String attachmentName = String.format("%s.txt", UUID.randomUUID());
        String content = "ATTACHMENT CONTENT";
        String attachmentsUri = this.getUriBuilder(AttachmentsResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome", attachmentName}).toString();
        HttpClient httpClient = new HttpClient();
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("Admin", "admin"));
        httpClient.getParams().setAuthenticationPreemptive(true);
        Part[] parts = new Part[1];
        ByteArrayPartSource baps = new ByteArrayPartSource(attachmentName, "ATTACHMENT CONTENT".getBytes());
        parts[0] = new FilePart(attachmentName, (PartSource)baps);
        PostMethod postMethod = new PostMethod(attachmentsUri);
        MultipartRequestEntity mpre = new MultipartRequestEntity(parts, postMethod.getParams());
        postMethod.setRequestEntity((RequestEntity)mpre);
        httpClient.executeMethod((HttpMethod)postMethod);
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)201, (int)postMethod.getStatusCode());
        this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        Header location = postMethod.getResponseHeader("location");
        GetMethod getMethod = this.executeGet(location.getValue());
        AttachmentsResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        AttachmentsResourceTest.assertEquals((String)"ATTACHMENT CONTENT", (String)getMethod.getResponseBodyAsString());
    }
}

