/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import java.util.Locale;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.jackrabbit.uuid.UUID;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Pages;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Spaces;
import org.xwiki.rest.model.jaxb.Syntaxes;
import org.xwiki.rest.model.jaxb.Translation;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.pages.PageChildrenResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class PageResourceTest
extends AbstractHttpTest {
    private Page getFirstPage() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        PageResourceTest.assertTrue((wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        Wiki wiki = (Wiki)wikis.getWikis().get(0);
        Link link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/spaces");
        PageResourceTest.assertNotNull((Object)link);
        getMethod = this.executeGet(link.getHref());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Spaces spaces = (Spaces)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        PageResourceTest.assertTrue((spaces.getSpaces().size() > 0 ? 1 : 0) != 0);
        Space space = (Space)spaces.getSpaces().get(0);
        link = this.getFirstLinkByRelation((LinkCollection)space, "http://www.xwiki.org/rel/pages");
        PageResourceTest.assertNotNull((Object)link);
        getMethod = this.executeGet(link.getHref());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        PageResourceTest.assertTrue((pages.getPageSummaries().size() > 0 ? 1 : 0) != 0);
        PageSummary pageSummary = (PageSummary)pages.getPageSummaries().get(0);
        link = this.getFirstLinkByRelation((LinkCollection)pageSummary, "http://www.xwiki.org/rel/page");
        PageResourceTest.assertNotNull((Object)link);
        getMethod = this.executeGet(link.getHref());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        return page;
    }

    public void testRepresentation() throws Exception {
        Page page = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "self");
        PageResourceTest.assertNotNull((Object)link);
        this.checkLinks((LinkCollection)page);
    }

    public void testGETNotExistingPage() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "NOTEXISTING", "NOTEXISTING"}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
    }

    public void testPUTPage() throws Exception {
        String CONTENT = String.format("This is a content (%d)", System.currentTimeMillis());
        String TITLE = String.format("Title (%s)", UUID.randomUUID().toString());
        Page originalPage = this.getFirstPage();
        Page newPage = this.objectFactory.createPage();
        newPage.setContent(CONTENT);
        newPage.setTitle(TITLE);
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        PageResourceTest.assertNotNull((Object)link);
        PutMethod putMethod = this.executePutXml(link.getHref(), newPage, "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        PageResourceTest.assertEquals((String)modifiedPage.getContent(), (String)CONTENT);
        PageResourceTest.assertEquals((String)modifiedPage.getTitle(), (String)TITLE);
    }

    public void testPUTPageWithTextPlain() throws Exception {
        String CONTENT = String.format("This is a content (%d)", System.currentTimeMillis());
        Page originalPage = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        PageResourceTest.assertNotNull((Object)link);
        PutMethod putMethod = this.executePut(link.getHref(), CONTENT, "text/plain", "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        PageResourceTest.assertEquals((String)modifiedPage.getContent(), (String)CONTENT);
    }

    public void testPUTPageUnauthorized() throws Exception {
        Page page = this.getFirstPage();
        page.setContent("New content");
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "self");
        PageResourceTest.assertNotNull((Object)link);
        PutMethod putMethod = this.executePutXml(link.getHref(), page);
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)401, (int)putMethod.getStatusCode());
    }

    public void testPUTNonExistingPage() throws Exception {
        String SPACE_NAME = "Test";
        String PAGE_NAME = String.format("Test-%d", System.currentTimeMillis());
        String CONTENT = String.format("Content %d", System.currentTimeMillis());
        String TITLE = String.format("Title %d", System.currentTimeMillis());
        String PARENT = "Main.WebHome";
        Page page = this.objectFactory.createPage();
        page.setContent(CONTENT);
        page.setTitle(TITLE);
        page.setParent("Main.WebHome");
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", PAGE_NAME}).toString(), page, "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        PageResourceTest.assertEquals((String)CONTENT, (String)modifiedPage.getContent());
        PageResourceTest.assertEquals((String)TITLE, (String)modifiedPage.getTitle());
        PageResourceTest.assertEquals((String)"Main.WebHome", (String)modifiedPage.getParent());
    }

    public void testPUTWithInvalidRepresentation() throws Exception {
        Page page = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)page, "self");
        PutMethod putMethod = this.executePut(link.getHref(), "<?xml version=\"1.0\" encoding=\"UTF-8\"?><invalidPage><content/></invalidPage>", "text/xml");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)400, (int)putMethod.getStatusCode());
    }

    private void createPageIfDoesntExist(String spaceName, String pageName, String content) throws Exception {
        String uri = this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), spaceName, pageName}).toString();
        GetMethod getMethod = this.executeGet(uri);
        if (getMethod.getStatusCode() == 404) {
            Page page = this.objectFactory.createPage();
            page.setContent(content);
            PutMethod putMethod = this.executePutXml(uri, page, "Admin", "admin");
            PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
            getMethod = this.executeGet(uri);
            PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        }
    }

    public void testPUTTranslation() throws Exception {
        String[] languages = Locale.getISOLanguages();
        String languageId = languages[this.random.nextInt(languages.length)];
        this.createPageIfDoesntExist("Test", "Translations", "Translations");
        Page page = this.objectFactory.createPage();
        page.setContent(languageId);
        PutMethod putMethod = this.executePutXml(this.getUriBuilder(PageTranslationResource.class).build(new Object[]{this.getWiki(), "Test", "Translations", languageId}).toString(), page, "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)201, (int)putMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageTranslationResource.class).build(new Object[]{this.getWiki(), "Test", "Translations", languageId}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        PageResourceTest.assertEquals((String)languageId, (String)modifiedPage.getLanguage());
        PageResourceTest.assertEquals((String)languageId, (String)modifiedPage.getLanguage());
    }

    public void testGETTranslations() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Translations"}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        PageResourceTest.assertTrue((page.getTranslations().getTranslations().size() > 0 ? 1 : 0) != 0);
        for (Translation translation : page.getTranslations().getTranslations()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)translation, "http://www.xwiki.org/rel/page").getHref());
            PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            PageResourceTest.assertEquals((String)page.getLanguage(), (String)translation.getLanguage());
            this.checkLinks((LinkCollection)translation);
        }
    }

    public void testGETNotExistingTranslation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", "Translations"}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        getMethod = this.executeGet(this.getUriBuilder(PageTranslationResource.class).build(new Object[]{this.getWiki(), "Test", "Translations", "NOT_EXISTING"}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
    }

    public void testDELETEPage() throws Exception {
        String pageName = String.format("Test-%d", this.random.nextLong());
        this.createPageIfDoesntExist("Test", pageName, "Test page");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString(), "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (int)204, (int)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)404, (int)getMethod.getStatusCode());
    }

    public void testDELETEPageNoRights() throws Exception {
        String pageName = String.format("Test-%d", this.random.nextLong());
        this.createPageIfDoesntExist("Test", pageName, "Test page");
        DeleteMethod deleteMethod = this.executeDelete(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)deleteMethod), (int)401, (int)deleteMethod.getStatusCode());
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Test", pageName}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
    }

    public void testPageHistory() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Page originalPage = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        String pageHistoryUri = this.getUriBuilder(PageHistoryResource.class).build(new Object[]{this.getWiki(), originalPage.getSpace(), originalPage.getName()}).toString();
        getMethod = this.executeGet(pageHistoryUri);
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        History history = (History)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (HistorySummary historySummary : history.getHistorySummaries()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)historySummary, "http://www.xwiki.org/rel/page").getHref());
            PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            this.checkLinks((LinkCollection)page);
            for (Translation translation : page.getTranslations().getTranslations()) {
                this.checkLinks((LinkCollection)translation);
            }
        }
    }

    public void testPageTranslationHistory() throws Exception {
        String pageHistoryUri = this.getUriBuilder(PageHistoryResource.class).build(new Object[]{this.getWiki(), "Test", "Translations"}).toString();
        GetMethod getMethod = this.executeGet(pageHistoryUri);
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        History history = (History)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        for (HistorySummary historySummary : history.getHistorySummaries()) {
            getMethod = this.executeGet(this.getFirstLinkByRelation((LinkCollection)historySummary, "http://www.xwiki.org/rel/page").getHref());
            PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
            Page page = (Page)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
            this.checkLinks((LinkCollection)page);
            this.checkLinks((LinkCollection)page.getTranslations());
        }
    }

    public void testGETPageChildren() throws Exception {
        GetMethod getMethod = this.executeGet(this.getUriBuilder(PageChildrenResource.class).build(new Object[]{this.getWiki(), "Main", "WebHome"}).toString());
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Pages pages = (Pages)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        PageResourceTest.assertTrue((pages.getPageSummaries().size() > 0 ? 1 : 0) != 0);
        for (PageSummary pageSummary : pages.getPageSummaries()) {
            this.checkLinks((LinkCollection)pageSummary);
        }
    }

    public void testPOSTPageFormUrlEncoded() throws Exception {
        String CONTENT = String.format("This is a content (%d)", System.currentTimeMillis());
        String TITLE = String.format("Title (%s)", UUID.randomUUID().toString());
        Page originalPage = this.getFirstPage();
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        PageResourceTest.assertNotNull((Object)link);
        NameValuePair[] nameValuePairs = new NameValuePair[]{new NameValuePair("title", TITLE), new NameValuePair("content", CONTENT)};
        PostMethod postMethod = this.executePostForm(String.format("%s?method=PUT", link.getHref()), nameValuePairs, "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)postMethod), (int)202, (int)postMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(postMethod.getResponseBodyAsStream());
        PageResourceTest.assertEquals((String)modifiedPage.getContent(), (String)CONTENT);
        PageResourceTest.assertEquals((String)modifiedPage.getTitle(), (String)TITLE);
    }

    public void testPUTPageSyntax() throws Exception {
        Page originalPage = this.getFirstPage();
        GetMethod getMethod = this.executeGet(this.getFullUri(SyntaxesResource.class));
        Syntaxes syntaxes = (Syntaxes)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        String newSyntax = null;
        for (String syntax : syntaxes.getSyntaxes()) {
            if (syntax.equals(originalPage.getSyntax())) continue;
            newSyntax = syntax;
            break;
        }
        originalPage.setSyntax(newSyntax);
        Link link = this.getFirstLinkByRelation((LinkCollection)originalPage, "self");
        PageResourceTest.assertNotNull((Object)link);
        PutMethod putMethod = this.executePutXml(link.getHref(), originalPage, "Admin", "admin");
        PageResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)putMethod), (int)202, (int)putMethod.getStatusCode());
        Page modifiedPage = (Page)this.unmarshaller.unmarshal(putMethod.getResponseBodyAsStream());
        PageResourceTest.assertEquals((String)newSyntax, (String)modifiedPage.getSyntax());
    }
}

