/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.rest;

import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.LinkCollection;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.model.jaxb.SearchResults;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Spaces;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.spaces.SpaceAttachmentsResource;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.test.rest.framework.AbstractHttpTest;

public class SpacesResourceTest
extends AbstractHttpTest {
    public void testRepresentation() throws Exception {
        GetMethod getMethod = this.executeGet(this.getFullUri(WikisResource.class));
        SpacesResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Wikis wikis = (Wikis)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        SpacesResourceTest.assertTrue((wikis.getWikis().size() > 0 ? 1 : 0) != 0);
        Wiki wiki = (Wiki)wikis.getWikis().get(0);
        Link link = this.getFirstLinkByRelation((LinkCollection)wiki, "http://www.xwiki.org/rel/spaces");
        SpacesResourceTest.assertNotNull((Object)link);
        getMethod = this.executeGet(link.getHref());
        SpacesResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Spaces spaces = (Spaces)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        SpacesResourceTest.assertTrue((spaces.getSpaces().size() > 0 ? 1 : 0) != 0);
        for (Space space : spaces.getSpaces()) {
            link = this.getFirstLinkByRelation((LinkCollection)space, "http://www.xwiki.org/rel/search");
            SpacesResourceTest.assertNotNull((Object)link);
            this.checkLinks((LinkCollection)space);
        }
    }

    public void testSearch() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s?q=somethingthatcannotpossiblyexist", this.getUriBuilder(SpaceSearchResource.class).build(new Object[]{this.getWiki(), "Main"})));
        SpacesResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        SearchResults searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        SpacesResourceTest.assertEquals((int)0, (int)searchResults.getSearchResults().size());
        getMethod = this.executeGet(String.format("%s?q=sandbox", this.getUriBuilder(WikiSearchResource.class).build(new Object[]{this.getWiki(), "Sandbox"})));
        SpacesResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        searchResults = (SearchResults)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        int resultSize = searchResults.getSearchResults().size();
        SpacesResourceTest.assertTrue((String)("Found " + resultSize + " result"), (resultSize >= 2 ? 1 : 0) != 0);
        for (SearchResult searchResult : searchResults.getSearchResults()) {
            this.checkLinks((LinkCollection)searchResult);
        }
    }

    public void testAttachments() throws Exception {
        GetMethod getMethod = this.executeGet(String.format("%s", this.getUriBuilder(SpaceAttachmentsResource.class).build(new Object[]{this.getWiki(), "Sandbox"})));
        SpacesResourceTest.assertEquals((String)this.getHttpMethodInfo((HttpMethod)getMethod), (int)200, (int)getMethod.getStatusCode());
        Attachments attachments = (Attachments)this.unmarshaller.unmarshal(getMethod.getResponseBodyAsStream());
        SpacesResourceTest.assertEquals((String)this.getAttachmentsInfo(attachments), (int)1, (int)attachments.getAttachments().size());
        for (Attachment attachment : attachments.getAttachments()) {
            this.checkLinks((LinkCollection)attachment);
        }
    }
}

