/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.webdav;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.webdav.lib.methods.DeleteMethod;
import org.apache.webdav.lib.methods.MkcolMethod;
import org.apache.webdav.lib.methods.MoveMethod;
import org.xwiki.test.webdav.AbstractWebDAVTest;

public class DefaultWebDAVTest
extends AbstractWebDAVTest {
    public void testCreateAndDeleteSpace() {
        String spaceUrl = "http://localhost:8080/xwiki/webdav/spaces/TestSpace";
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        try {
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            mkColMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
        }
        catch (HttpException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
    }

    public void testRenameSpace() {
        String spaceUrl = "http://localhost:8080/xwiki/webdav/spaces/TestSpace";
        String relativeDestinationPath = "/xwiki/webdav/spaces/RenamedTestSpace";
        String movedSpaceUrl = "http://localhost:8080/xwiki/webdav/spaces/RenamedTestSpace";
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        MoveMethod moveMethod = new MoveMethod();
        moveMethod.setDoAuthentication(true);
        try {
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            deleteMethod.setPath(movedSpaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            mkColMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            moveMethod.setPath(spaceUrl);
            moveMethod.setDestination(relativeDestinationPath);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)moveMethod));
            deleteMethod.setPath(movedSpaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
        }
        catch (HttpException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
    }

    public void testCreateAndDeletePage() {
        String spaceUrl = "http://localhost:8080/xwiki/webdav/spaces/TestSpace";
        String pageUrl = spaceUrl + "/TestPage";
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        try {
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            mkColMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            mkColMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            deleteMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
        }
        catch (HttpException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
    }

    public void testGetPageWikiContent() {
        String spaceUrl = "http://localhost:8080/xwiki/webdav/spaces/TestSpace";
        String pageUrl = spaceUrl + "/TestPage";
        String wikiTextFileUrl = pageUrl + "/wiki.txt";
        String wikiXMLFileUrl = pageUrl + "/wiki.xml";
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        GetMethod getMethod = new GetMethod();
        getMethod.setDoAuthentication(true);
        try {
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            mkColMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            mkColMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            getMethod.setPath(wikiTextFileUrl);
            DefaultWebDAVTest.assertEquals((int)200, (int)this.getHttpClient().executeMethod((HttpMethod)getMethod));
            DefaultWebDAVTest.assertTrue((getMethod.getResponseBodyAsStream().read() != -1 ? 1 : 0) != 0);
            getMethod.setPath(wikiXMLFileUrl);
            DefaultWebDAVTest.assertEquals((int)200, (int)this.getHttpClient().executeMethod((HttpMethod)getMethod));
            DefaultWebDAVTest.assertTrue((getMethod.getResponseBodyAsStream().read() != -1 ? 1 : 0) != 0);
            deleteMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
        }
        catch (HttpException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
    }

    public void testUpdatePageWikiContent() {
        String spaceUrl = "http://localhost:8080/xwiki/webdav/spaces/TestSpace";
        String pageUrl = spaceUrl + "/TestPage";
        String wikiTextFileUrl = pageUrl + "/wiki.txt";
        String wikiXMLFileUrl = pageUrl + "/wiki.xml";
        String newContent = "New Content";
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        PutMethod putMethod = new PutMethod();
        putMethod.setDoAuthentication(true);
        GetMethod getMethod = new GetMethod();
        getMethod.setDoAuthentication(true);
        try {
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            mkColMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            mkColMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            putMethod.setPath(wikiTextFileUrl);
            putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(newContent.getBytes())));
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)putMethod));
            getMethod.setPath(wikiTextFileUrl);
            DefaultWebDAVTest.assertEquals((int)200, (int)this.getHttpClient().executeMethod((HttpMethod)getMethod));
            DefaultWebDAVTest.assertEquals((String)newContent, (String)getMethod.getResponseBodyAsString());
            putMethod.setPath(wikiXMLFileUrl);
            putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(newContent.getBytes())));
            DefaultWebDAVTest.assertEquals((int)405, (int)this.getHttpClient().executeMethod((HttpMethod)putMethod));
            deleteMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
        }
        catch (HttpException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
    }

    public void testMakingAttachment() {
        String spaceUrl = "http://localhost:8080/xwiki/webdav/spaces/TestSpace";
        String pageUrl = spaceUrl + "/TestPage";
        String attachmentUrl = pageUrl + "/attachment.txt";
        String attachmentContent = "Attachment Content";
        DeleteMethod deleteMethod = new DeleteMethod();
        deleteMethod.setDoAuthentication(true);
        MkcolMethod mkColMethod = new MkcolMethod();
        mkColMethod.setDoAuthentication(true);
        PutMethod putMethod = new PutMethod();
        putMethod.setDoAuthentication(true);
        GetMethod getMethod = new GetMethod();
        getMethod.setDoAuthentication(true);
        try {
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            mkColMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            mkColMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)mkColMethod));
            getMethod.setPath(attachmentUrl);
            DefaultWebDAVTest.assertEquals((int)404, (int)this.getHttpClient().executeMethod((HttpMethod)getMethod));
            putMethod.setPath(attachmentUrl);
            putMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(attachmentContent.getBytes())));
            DefaultWebDAVTest.assertEquals((int)201, (int)this.getHttpClient().executeMethod((HttpMethod)putMethod));
            getMethod.setPath(attachmentUrl);
            DefaultWebDAVTest.assertEquals((int)200, (int)this.getHttpClient().executeMethod((HttpMethod)getMethod));
            DefaultWebDAVTest.assertEquals((String)attachmentContent, (String)getMethod.getResponseBodyAsString());
            deleteMethod.setPath(attachmentUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            deleteMethod.setPath(pageUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
            deleteMethod.setPath(spaceUrl);
            DefaultWebDAVTest.assertEquals((int)204, (int)this.getHttpClient().executeMethod((HttpMethod)deleteMethod));
        }
        catch (HttpException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
        catch (IOException ex) {
            DefaultWebDAVTest.fail((String)ex.getMessage());
        }
    }
}

