/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc;

import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.test.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.test.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.Utils;
import org.xwiki.xmlrpc.model.XWikiPage;

public class AttachmentsTest
extends AbstractXWikiXmlRpcTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.rpc.removePage("Test.Attachments");
        }
        catch (XmlRpcException e) {
            // empty catch block
        }
        XWikiPage page = new XWikiPage();
        page.setId("Test.Attachments");
        this.rpc.storePage((Page)page);
        this.addAttachment("first.txt", "Content of first attachment.");
    }

    private Attachment addAttachment(String fileName, String content) throws Exception {
        Attachment attachment = new Attachment();
        attachment.setPageId("Test.Attachments");
        attachment.setFileName(fileName);
        return this.rpc.addAttachment(Integer.valueOf(0), attachment, content.getBytes());
    }

    public void testAddAttachment() throws Exception {
        String attachmentName = String.format("test_attachment_%d.png", this.random.nextInt());
        String attachmentData = "Data for " + attachmentName;
        Attachment attachment = this.addAttachment(attachmentName, "Data for " + attachmentName);
        TestUtils.banner("TEST: addAttachment()");
        System.out.format("%s\n", attachment);
        AttachmentsTest.assertEquals((int)attachmentData.getBytes().length, (int)Integer.parseInt(attachment.getFileSize()));
        AttachmentsTest.assertEquals((String)attachmentData, (String)new String(this.rpc.getAttachmentData(attachment.getPageId(), attachment.getFileName(), "1.1")));
    }

    public void testGetAttachments() throws Exception {
        List attachments = this.rpc.getAttachments("Test.Attachments");
        TestUtils.banner("TEST: getAttachments()");
        for (Attachment attachment : attachments) {
            System.out.format("%s\n", attachment);
        }
        AttachmentsTest.assertFalse((boolean)attachments.isEmpty());
    }

    public void testGetAttachmentData() throws Exception {
        List attachments = this.rpc.getAttachments("Test.Attachments");
        Attachment attachment = (Attachment)attachments.get(0);
        byte[] content = this.rpc.getAttachmentData(attachment.getPageId(), attachment.getFileName(), "1.1");
        TestUtils.banner("getAttachmentData()");
        System.out.format("%s\n", attachment);
        System.out.format("Content = %s\n", Utils.truncateToFirstLine((String)new String(content, 0, content.length > 32 ? 32 : content.length)));
        int contentLength = new Integer(attachment.getFileSize());
        AttachmentsTest.assertTrue((content.length == contentLength ? 1 : 0) != 0);
    }

    public void testRemoveAttachment() throws Exception {
        List attachments = this.rpc.getAttachments("Test.Attachments");
        Attachment attachmentToBeRemoved = (Attachment)attachments.get(this.random.nextInt(attachments.size()));
        TestUtils.banner("TEST: testRemoveAttachment()");
        System.out.format("Before: %s\n", attachments);
        Boolean result = this.rpc.removeAttachment(attachmentToBeRemoved.getPageId(), attachmentToBeRemoved.getFileName());
        System.out.format("Result: %b\n", result);
        attachments = this.rpc.getAttachments("Test.Attachments");
        System.out.format("After: %s\n", attachments);
        boolean found = false;
        for (Attachment attachment : attachments) {
            if (!attachment.getFileName().equals(attachmentToBeRemoved.getFileName())) continue;
            found = true;
            break;
        }
        AttachmentsTest.assertFalse((boolean)found);
    }
}

