/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc;

import java.util.List;
import junit.framework.Assert;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.test.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.test.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiPage;

public class RenderingTest
extends AbstractXWikiXmlRpcTest {
    public void testGetInputSyntaxes() throws XmlRpcException {
        List syntaxes = this.rpc.getInputSyntaxes();
        TestUtils.banner("TEST: getInputSyntaxes()");
        System.out.format("%d conversion input syntaxes found:\n", syntaxes.size());
        for (String syntaxId : syntaxes) {
            System.out.format("%s\n", syntaxId);
        }
        Assert.assertTrue((syntaxes.size() != 0 ? 1 : 0) != 0);
    }

    public void testGetOutputSyntaxes() throws XmlRpcException {
        List syntaxes = this.rpc.getOutputSyntaxes();
        TestUtils.banner("TEST: getOutputSyntaxes()");
        System.out.format("%d conversion output syntaxes found:\n", syntaxes.size());
        for (String syntaxId : syntaxes) {
            System.out.format("%s\n", syntaxId);
        }
        Assert.assertTrue((syntaxes.size() != 0 ? 1 : 0) != 0);
    }

    public void testConvert() throws XmlRpcException {
        String inputXWiki = "**BoldText**//ItalicText//" + String.format("%n", new Object[0]) + "==h2Text==" + String.format("%n", new Object[0]) + "normalText";
        String inputXhtml = "<div><p><strong>boldText</strong><br/><em>ItalicText</em></p>" + String.format("%n", new Object[0]) + "<h2 id=\"h2Text\"><span>h2Text</span></h2><p>normalText</p></div>";
        TestUtils.banner("TEST: convert()");
        System.out.format("\nTesting xwiki/2.0 -> xhtml/1.0 conversion\n", new Object[0]);
        System.out.format("Input text:\n%s", inputXWiki);
        String outputXhtml = this.rpc.convert(inputXhtml, "xwiki/2.0", "xhtml/1.0");
        System.out.format("\nOutput text:\n%s", outputXhtml);
        Assert.assertNotNull((Object)outputXhtml);
        Assert.assertFalse((boolean)outputXhtml.equals(""));
        Assert.assertTrue((boolean)outputXhtml.contains("strong"));
        Assert.assertTrue((boolean)outputXhtml.contains("normalText"));
        Assert.assertTrue((boolean)outputXhtml.contains("ItalicText"));
        System.out.format("\nTesting xhtml/1.0 -> xwiki/2.0 conversion\n", new Object[0]);
        System.out.format("Input text:\n%s", inputXhtml);
        String outputXWiki = this.rpc.convert(inputXhtml, "xhtml/1.0", "xwiki/2.0");
        System.out.format("\nOutput text:\n%s\n", outputXWiki);
        Assert.assertNotNull((Object)outputXWiki);
        Assert.assertFalse((boolean)outputXhtml.equals(""));
        Assert.assertTrue((boolean)outputXhtml.contains("normalText"));
        Assert.assertTrue((boolean)outputXhtml.contains("ItalicText"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRenderedContent() throws XmlRpcException {
        String pageContent = "**Text in Bold**{{velocity}}VelocityCode{{/velocity}}";
        XWikiPage page = new XWikiPage();
        page.setId("Test.Test");
        page.setContent(pageContent);
        page.setSyntaxId("xwiki/2.0");
        TestUtils.banner("TEST: getRenderedContent()");
        System.out.format("\nCalling getRenderedContent for page %s\n", page.getId());
        System.out.format("\nWiki content is:\n%s\n", pageContent);
        this.rpc.storePage((Page)page);
        try {
            String renderedContent = this.rpc.getRenderedContent(page.getId(), "annotatedxhtml/1.0");
            System.out.format("\nObtained rendered content:\n%s\n\n", renderedContent);
            Assert.assertTrue((boolean)renderedContent.contains("Text in Bold"));
            Assert.assertTrue((boolean)renderedContent.contains("startmacro"));
        }
        finally {
            this.rpc.removePage(page.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenderPageContent() throws XmlRpcException {
        String pageContent = "**Text in Bold**{{velocity}}VelocityCode{{/velocity}}";
        XWikiPage page = new XWikiPage();
        page.setId("Test.Test");
        page.setContent(pageContent);
        page.setSyntaxId("xwiki/2.0");
        TestUtils.banner("TEST: renderPageContent");
        System.out.format("\nCalling renderPageContent with context as page %s\n", "Test.Test");
        System.out.format("\nWiki content is:\n%s\n", pageContent);
        this.rpc.storePage((Page)page);
        try {
            String renderedContent = this.rpc.renderPageContent(page.getId(), page.getContent(), page.getSyntaxId(), "annotatedxhtml/1.0");
            System.out.format("\nObtained rendered content:\n%s\n\n", renderedContent);
            Assert.assertTrue((boolean)renderedContent.contains("Text in Bold"));
            Assert.assertTrue((boolean)renderedContent.contains("startmacro"));
        }
        finally {
            this.rpc.removePage(page.getId());
        }
    }
}

