/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc.confluence;

import java.util.List;
import org.codehaus.swizzle.confluence.Attachment;
import org.codehaus.swizzle.confluence.Page;
import org.codehaus.swizzle.confluence.Space;
import org.xwiki.test.xmlrpc.confluence.framework.AbstractXmlRpcTestCase;

public class AttachmentsTest
extends AbstractXmlRpcTestCase {
    private String pageId;
    private String spaceKey;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.spaceKey = "SomeSpaceReally";
        Space space = new Space();
        space.setKey(this.spaceKey);
        space.setName("Some Name");
        this.rpc.addSpace(space);
        String pageTitle = "SomePage";
        Page p = new Page();
        p.setSpace(this.spaceKey);
        p.setTitle(pageTitle);
        p.setContent("Dummy Comment");
        Page resultPage = this.rpc.storePage(p);
        this.pageId = resultPage.getId();
    }

    @Override
    public void tearDown() throws Exception {
        this.rpc.removePage(this.pageId);
        this.rpc.removeSpace(this.spaceKey);
        super.tearDown();
    }

    public void testAttachments() throws Exception {
        Attachment attach0 = new Attachment();
        String fileName = "test.txt";
        String contentType = "text/plain";
        attach0.setFileName(fileName);
        attach0.setPageId(this.pageId);
        attach0.setContentType(contentType);
        byte[] data0 = new byte[]{116, 101, 115, 116};
        Attachment attach00 = this.rpc.addAttachment(0, attach0, data0);
        AttachmentsTest.assertEquals((String)this.pageId, (String)attach00.getPageId());
        AttachmentsTest.assertEquals((String)fileName, (String)attach00.getFileName());
        AttachmentsTest.assertEquals((String)fileName, (String)attach00.getTitle());
        AttachmentsTest.assertEquals((String)("" + data0.length), (String)attach00.getFileSize());
        AttachmentsTest.assertEquals((String)contentType, (String)attach00.getContentType());
        byte[] data00 = this.rpc.getAttachmentData(this.pageId, fileName, "");
        AttachmentsTest.assertEquals((int)data0.length, (int)data00.length);
        for (int i = 0; i < data0.length; ++i) {
            AttachmentsTest.assertEquals((byte)data0[i], (byte)data00[i]);
        }
        this.rpc.removeAttachment(this.pageId, fileName);
        List list = this.rpc.getAttachments(this.pageId);
        AttachmentsTest.assertTrue((boolean)list.isEmpty());
        Attachment attach1 = new Attachment();
        String fileName1 = "file1";
        attach1.setFileName(fileName1);
        attach1.setPageId(this.pageId);
        attach1.setContentType("");
        byte[] data1 = new byte[]{};
        this.rpc.addAttachment(0, attach1, data1);
        Attachment attach2 = new Attachment();
        String fileName2 = "file2";
        attach2.setFileName(fileName2);
        attach2.setPageId(this.pageId);
        attach2.setContentType("");
        byte[] data2 = new byte[]{};
        this.rpc.addAttachment(0, attach2, data2);
        list = this.rpc.getAttachments(this.pageId);
        AttachmentsTest.assertEquals((int)2, (int)list.size());
        AttachmentsTest.assertEquals((String)fileName1, (String)((Attachment)list.get(0)).getFileName());
        AttachmentsTest.assertEquals((String)fileName2, (String)((Attachment)list.get(1)).getFileName());
        this.rpc.removeAttachment(this.pageId, fileName1);
        this.rpc.removeAttachment(this.pageId, fileName2);
        list = this.rpc.getAttachments(this.pageId);
        AttachmentsTest.assertTrue((boolean)list.isEmpty());
    }
}

