/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.test.xmlrpc;

import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.swizzle.confluence.Comment;
import org.codehaus.swizzle.confluence.Page;
import org.xwiki.test.xmlrpc.AbstractXWikiXmlRpcTest;
import org.xwiki.test.xmlrpc.TestUtils;
import org.xwiki.xmlrpc.model.XWikiPage;

public class CommentsTest
extends AbstractXWikiXmlRpcTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.rpc.removePage("Test.Comments");
        }
        catch (XmlRpcException e) {
            // empty catch block
        }
        XWikiPage page = new XWikiPage();
        page.setId("Test.Comments");
        this.rpc.storePage((Page)page);
        this.addComment("This is the first comment.");
    }

    private Comment addComment(String content) throws Exception {
        Comment comment = new Comment();
        comment.setPageId("Test.Comments");
        comment.setContent(content);
        return this.rpc.addComment(comment);
    }

    public void testAddComment() throws Exception {
        String content = String.format("This is a new comment!!! %s", this.random.nextInt());
        Comment comment = this.addComment(content);
        TestUtils.banner("TEST: getComments()");
        System.out.format("%s\n", comment);
        CommentsTest.assertNotSame((Object)"NEW", (Object)comment.getId());
        CommentsTest.assertEquals((String)content, (String)comment.getContent());
        CommentsTest.assertEquals((String)String.format("XWiki.%s", "Admin"), (String)comment.getCreator());
    }

    public void testGetComments() throws Exception {
        List comments = this.rpc.getComments("Test.Comments");
        TestUtils.banner("TEST: getComments()");
        for (Comment comment : comments) {
            System.out.format("%s\n", comment);
        }
        CommentsTest.assertFalse((boolean)comments.isEmpty());
    }

    public void testRemoveComment() throws Exception {
        List comments = this.rpc.getComments("Test.Comments");
        Comment comment = (Comment)comments.get(this.random.nextInt(comments.size()));
        Boolean result = this.rpc.removeComment(comment.getId());
        TestUtils.banner("TEST: removeComment()");
        System.out.format("Comment removed = %b\n", result);
        comments = this.rpc.getComments("Test.Comments");
        boolean found = false;
        for (Comment c : comments) {
            if (!c.getId().equals(comment.getId())) continue;
            found = true;
            break;
        }
        CommentsTest.assertFalse((boolean)found);
    }
}

