/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.validator;

import org.xml.sax.SAXParseException;

public class ValidationError {
    private final Type type;
    private final int line;
    private final int column;
    private final String message;

    public ValidationError(Type type, int line, int column, String message) {
        this.type = type;
        this.line = line;
        this.column = column;
        this.message = message;
    }

    public ValidationError(Type type, SAXParseException e) {
        this.type = type;
        this.line = e.getLineNumber();
        this.column = e.getColumnNumber();
        this.message = e.getMessage();
    }

    public Type getType() {
        return this.type;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        String prefix = this.getType().equals((Object)Type.ERROR) ? "ERROR: " : (this.getType().equals((Object)Type.WARNING) ? "WARNING: " : "FATAL: ");
        return prefix + this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        WARNING,
        ERROR,
        FATAL;

    }
}

