/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.validator;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.Validator;
import org.xwiki.validator.framework.XMLErrorHandler;
import org.xwiki.validator.framework.XMLResourcesEntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLValidator
implements Validator {
    private XMLErrorHandler errorHandler = new XMLErrorHandler();
    private InputStream document;
    private DocumentBuilder documentBuilder;

    public XHTMLValidator() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            this.documentBuilder = factory.newDocumentBuilder();
            this.documentBuilder.setEntityResolver(new XMLResourcesEntityResolver());
            this.documentBuilder.setErrorHandler(this.errorHandler);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setDocument(InputStream document) {
        this.document = document;
    }

    @Override
    public List<ValidationError> validate() {
        try {
            this.errorHandler.clear();
            this.documentBuilder.parse(this.document);
        }
        catch (SAXException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.errorHandler.getErrors();
    }

    @Override
    public List<ValidationError> getErrors() {
        return this.errorHandler.getErrors();
    }

    @Override
    public void clear() {
        this.errorHandler.clear();
    }
}

