/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.validator.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.framework.AbstractXMLValidator;
import org.xwiki.validator.framework.NodeListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDOMValidator
extends AbstractXMLValidator {
    protected static final String XPATH_CATCHALL = "//";
    protected static final String SUBMIT = "submit";
    protected static final String IMAGE = "image";
    protected static final String RESET = "reset";
    protected static final String BUTTON = "button";
    protected static final String MAILTO = "mailto:";
    protected static final String HIDDEN = "hidden";
    protected static final String ELEM_HTML = "html";
    protected static final String ELEM_BODY = "body";
    protected static final String ELEM_H1 = "h1";
    protected static final String ELEM_BR = "br";
    protected static final String ELEM_BOLD = "b";
    protected static final String ELEM_ITALIC = "i";
    protected static final String ELEM_SUBMIT = "submit";
    protected static final String ELEM_FRAMESET = "frameset";
    protected static final String ELEM_FRAME = "frame";
    protected static final String ELEM_IFRAME = "iframe";
    protected static final String ELEM_LINK = "a";
    protected static final String ELEM_INPUT = "input";
    protected static final String ELEM_IMG = "img";
    protected static final String ELEM_AREA = "area";
    protected static final String ELEM_TABLE = "table";
    protected static final String ELEM_TH = "th";
    protected static final String ELEM_FORM = "form";
    protected static final String ELEM_FIELDSET = "fieldset";
    protected static final String ELEM_META = "meta";
    protected static final String ATTR_TYPE = "type";
    protected static final String ATTR_ALT = "alt";
    protected static final String ATTR_HREF = "href";
    protected static final String ATTR_BLUR = "onblur";
    protected static final String ATTR_CHANGE = "onchange";
    protected static final String ATTR_CLICK = "onclick";
    protected static final String ATTR_FOCUS = "onfocus";
    protected static final String ATTR_LOAD = "onload";
    protected static final String ATTR_MOUSEOVER = "onmouseover";
    protected static final String ATTR_SELECT = "onselect";
    protected static final String ATTR_SUBMIT = "onsubmit";
    protected static final String ATTR_UNLOAD = "unload";
    protected static final String ATTR_ACCESSKEY = "accesskey";
    protected static final String ATTR_SCOPE = "scope";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_CONTENT = "content";
    protected static final String ATTR_CHARSET = "charset";
    protected XPath xpath = XPathFactory.newInstance().newXPath();

    public AbstractDOMValidator() {
    }

    public AbstractDOMValidator(boolean validateXML) {
        super(validateXML);
    }

    protected void assertFalse(ValidationError.Type errorType, String message, boolean condition) {
        if (condition) {
            this.addError(errorType, -1, -1, message);
        }
    }

    protected void assertTrue(ValidationError.Type errorType, String message, boolean condition) {
        if (!condition) {
            this.addError(errorType, -1, -1, message);
        }
    }

    public boolean containsElement(String tagName) {
        return this.document.getElementsByTagName(tagName).getLength() > 0;
    }

    public NodeListIterable getElements(String tagName) {
        return new NodeListIterable(this.document.getElementsByTagName(tagName));
    }

    public Object evaluate(Node node, String exprString, QName returnType) {
        try {
            XPathExpression expr = this.xpath.compile(exprString);
            return expr.evaluate(this.document, returnType);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public NodeListIterable getElements(Collection<String> tagNames) {
        String exprString = StringUtils.join(tagNames, (String)"|//");
        return new NodeListIterable((NodeList)this.evaluate(this.document, exprString, XPathConstants.NODESET));
    }

    public boolean hasChildElement(Node element, String tagName) {
        String exprString = XPATH_CATCHALL + tagName;
        return (Boolean)this.evaluate(element, exprString, XPathConstants.BOOLEAN);
    }

    public NodeListIterable getChildren(Node element, String tagName) {
        String exprString = XPATH_CATCHALL + tagName;
        NodeList nodeList = (NodeList)this.evaluate(element, exprString, XPathConstants.NODESET);
        return new NodeListIterable(nodeList);
    }

    public List<String> getChildrenTagNames(Node element) {
        ArrayList<String> childrenTagNames = new ArrayList<String>();
        String exprString = "//*";
        NodeListIterable children = new NodeListIterable((NodeList)this.evaluate(element, exprString, XPathConstants.NODESET));
        for (Node child : children) {
            childrenTagNames.add(child.getNodeName());
        }
        return childrenTagNames;
    }

    public static boolean hasAttribute(Node element, String attributeName) {
        return AbstractDOMValidator.getAttributeNames(element).contains(attributeName);
    }

    public static List<String> getAttributeNames(Node element) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            attributeNames.add(attributes.item(i).getNodeName());
        }
        return attributeNames;
    }

    public static String getAttributeValue(Node element, String attributeName) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (!attribute.getNodeName().equals(attributeName)) continue;
            return attribute.getNodeValue();
        }
        return null;
    }

    public static List<String> getAttributeValues(NodeListIterable elements, String attributeName) {
        return AbstractDOMValidator.getAttributeValues(elements.getNodeList(), attributeName);
    }

    public static List<String> getAttributeValues(NodeList nodes, String attributeName) {
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node element = nodes.item(i);
            String value = AbstractDOMValidator.getAttributeValue(element, attributeName);
            if (value == null) continue;
            results.add(value);
        }
        return results;
    }

    public Node getElement(String tagName) {
        return this.getElements(tagName).getNodeList().item(0);
    }
}

