/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.validator.framework;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xwiki.validator.ValidationError;
import org.xwiki.validator.Validator;
import org.xwiki.validator.framework.XMLErrorHandler;
import org.xwiki.validator.framework.XMLResourcesEntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXMLValidator
implements Validator {
    protected Document document;
    private XMLErrorHandler errorHandler = new XMLErrorHandler();
    private DocumentBuilder documentBuilder;
    private boolean validateXML = true;

    public AbstractXMLValidator() {
        this(true);
    }

    public AbstractXMLValidator(boolean validateXML) {
        this.setValidateXML(validateXML);
        this.errorHandler = this.createXMLErrorHandler();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            this.documentBuilder = factory.newDocumentBuilder();
            this.documentBuilder.setEntityResolver(new XMLResourcesEntityResolver());
            this.documentBuilder.setErrorHandler(this.errorHandler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected XMLErrorHandler createXMLErrorHandler() {
        return new XMLErrorHandler();
    }

    public void setValidateXML(boolean validateXML) {
        this.validateXML = validateXML;
    }

    @Override
    public void setDocument(InputStream document) {
        this.document = null;
        if (document != null) {
            try {
                this.clear();
                this.document = this.documentBuilder.parse(document);
            }
            catch (SAXException e) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<ValidationError> validate() {
        if (this.document == null) {
            return this.errorHandler.getErrors();
        }
        if (!this.validateXML) {
            this.errorHandler.clear();
        }
        this.validate(this.document);
        return this.errorHandler.getErrors();
    }

    protected void validate(Document document) {
    }

    @Override
    public List<ValidationError> getErrors() {
        return this.errorHandler.getErrors();
    }

    @Override
    public void clear() {
        this.errorHandler.clear();
    }

    public Document getDocument() {
        return this.document;
    }

    protected XMLErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void addError(ValidationError.Type errorType, int line, int column, String message) {
        this.errorHandler.addError(new ValidationError(errorType, line, column, message));
    }
}

