/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.tool.xar;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

abstract class AbstractXarMojo
extends AbstractMojo {
    protected static final String HOOK_OPEN = "[";
    protected static final String HOOK_CLOSE = "]";
    protected static final String PACKAGE_XML = "package.xml";
    protected static final String FILES_TAG = "files";
    protected static final String FILE_TAG = "file";
    private static final String[] DEFAULT_EXCLUDES = new String[]{"**/META-INF/**"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    protected String[] includes;
    protected String[] excludes;
    protected MavenProject project;

    AbstractXarMojo() {
    }

    protected String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    protected String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }

    protected void unpack(File file, File location, String logName, boolean overwrite) throws MojoExecutionException {
        try {
            FileSelector[] selectors;
            ZipUnArchiver unArchiver = new ZipUnArchiver();
            unArchiver.enableLogging((Logger)new ConsoleLogger(3, logName));
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            IncludeExcludeFileSelector fs = new IncludeExcludeFileSelector();
            fs.setIncludes(this.getIncludes());
            fs.setExcludes(this.getExcludes());
            unArchiver.setOverwrite(overwrite);
            if (!overwrite) {
                IncludeExcludeFileSelector fs2 = new IncludeExcludeFileSelector();
                fs2.setExcludes(new String[]{PACKAGE_XML});
                selectors = new FileSelector[]{fs, fs2};
            } else {
                selectors = new FileSelector[]{fs};
            }
            unArchiver.setFileSelectors(selectors);
            unArchiver.extract();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error unpacking file [" + file + HOOK_CLOSE + " to " + HOOK_OPEN + location + HOOK_CLOSE, e);
        }
    }

    protected void unpackXarToOutputDirectory(Artifact artifact) throws MojoExecutionException {
        File outputLocation = new File(this.project.getBuild().getOutputDirectory());
        if (!outputLocation.exists()) {
            outputLocation.mkdirs();
        }
        File file = artifact.getFile();
        this.unpack(file, outputLocation, "XarMojo", false);
    }

    protected void unpackDependentXars() throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        for (Artifact artifact : artifacts) {
            String type;
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact) || !"xar".equals(type = artifact.getType())) continue;
            this.unpackXarToOutputDirectory(artifact);
        }
    }
}

