/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.action.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.action.Action;
import org.xwiki.action.ActionException;
import org.xwiki.action.ActionManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.container.Container;
import org.xwiki.url.XWikiEntityURL;
import org.xwiki.url.XWikiURL;
import org.xwiki.url.XWikiURLType;

@Component
@Singleton
public class DefaultActionManager
implements ActionManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Container container;
    @Inject
    @Named(value="error")
    private Action errorAction;

    public void handleRequest() throws ActionException {
        XWikiURL requestURL = (XWikiURL)this.container.getRequest().getProperty("xwikiurl");
        if (requestURL != null && requestURL.getType() == XWikiURLType.ENTITY) {
            String actionName = ((XWikiEntityURL)requestURL).getAction();
            this.handleRequest(actionName);
        }
    }

    public void handleRequest(String actionName) throws ActionException {
        this.handleRequest(actionName, null);
    }

    public void handleRequest(String actionName, Object additionalData) throws ActionException {
        try {
            Action action = (Action)this.componentManager.lookup(Action.class, actionName);
            action.execute(additionalData);
        }
        catch (Exception e) {
            this.errorAction.execute(e);
        }
    }
}

