/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client;

import io.searchbox.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Index;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.mapping.PutMapping;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.sf.json.JSONObject;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.activeinstalls.internal.client.PingSender;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultPingSender
implements PingSender {
    @Inject
    private JestClientManager jestClientManager;
    @Inject
    private Provider<List<PingDataProvider>> pingDataProviderProvider;

    @Override
    public void sendPing() throws Exception {
        JestClient client = this.jestClientManager.getClient();
        client.execute((Action)new CreateIndex.Builder("installs").build());
        PutMapping putMapping = new PutMapping.Builder("installs", "install2", (Object)this.constructJSONMapping()).build();
        client.execute((Action)putMapping);
        Index index = ((Index.Builder)((Index.Builder)new Index.Builder((Object)this.constructIndexJSON()).index("installs")).type("install2")).build();
        JestResult result = client.execute((Action)index);
        if (!result.isSucceeded()) {
            throw new Exception(result.getErrorMessage());
        }
    }

    private String constructJSONMapping() {
        HashMap jsonMap = new HashMap();
        HashMap<String, Boolean> timestampMap = new HashMap<String, Boolean>();
        timestampMap.put("enabled", true);
        timestampMap.put("store", true);
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (PingDataProvider pingDataProvider : (List)this.pingDataProviderProvider.get()) {
            propertiesMap.putAll(pingDataProvider.provideMapping());
        }
        jsonMap.put("_timestamp", timestampMap);
        jsonMap.put("properties", propertiesMap);
        return JSONObject.fromObject(Collections.singletonMap("install2", jsonMap)).toString();
    }

    private String constructIndexJSON() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        for (PingDataProvider pingDataProvider : (List)this.pingDataProviderProvider.get()) {
            jsonMap.putAll(pingDataProvider.provideData());
        }
        return JSONObject.fromObject(jsonMap).toString();
    }
}

