/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.client.data;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.activeinstalls.internal.client.PingDataProvider;
import org.xwiki.component.annotation.Component;
import org.xwiki.environment.Environment;
import org.xwiki.environment.internal.ServletEnvironment;

@Component
@Named(value="servlet")
@Singleton
public class ServletContainerPingDataProvider
implements PingDataProvider {
    private static final String SERVLET_INFO_VERSION_SEPARATOR = "/";
    private static final String SERVLET_INFO_OPTIONALSEPARATOR = "(";
    private static final String PROPERTY_SERVLET_CONTAINER_NAME = "servletContainerName";
    private static final String PROPERTY_SERVLET_CONTAINER_VERSION = "servletContainerVersion";
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;

    @Override
    public Map<String, Object> provideMapping() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "string");
        map.put("index", "not_analyzed");
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(PROPERTY_SERVLET_CONTAINER_NAME, map);
        propertiesMap.put(PROPERTY_SERVLET_CONTAINER_VERSION, map);
        return propertiesMap;
    }

    @Override
    public Map<String, Object> provideData() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        if (this.environment instanceof ServletEnvironment) {
            ServletEnvironment servletEnvironment = (ServletEnvironment)this.environment;
            try {
                ServletContext servletContext = servletEnvironment.getServletContext();
                String serverInfo = servletContext.getServerInfo();
                jsonMap.put(PROPERTY_SERVLET_CONTAINER_NAME, StringUtils.trim((String)StringUtils.substringBefore((String)serverInfo, (String)SERVLET_INFO_VERSION_SEPARATOR)));
                jsonMap.put(PROPERTY_SERVLET_CONTAINER_VERSION, StringUtils.trim((String)StringUtils.substringBefore((String)StringUtils.substringAfter((String)serverInfo, (String)SERVLET_INFO_VERSION_SEPARATOR), (String)SERVLET_INFO_OPTIONALSEPARATOR)));
            }
            catch (Throwable e) {
                this.logger.warn("Failed to compute Servlet container information. This information has not been added to the Active Installs ping data. Reason [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return jsonMap;
    }
}

