/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal;

import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.activeinstalls.ActiveInstallsConfiguration;
import org.xwiki.activeinstalls.internal.JestClientManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;

@Component
@Singleton
public class DefaultJestClientManager
implements JestClientManager,
Initializable,
Disposable {
    @Inject
    private ActiveInstallsConfiguration configuration;
    private JestClient client;

    public void initialize() throws InitializationException {
        String pingURL = this.configuration.getPingInstanceURL();
        HttpClientConfig clientConfig = ((HttpClientConfig.Builder)new HttpClientConfig.Builder(pingURL).multiThreaded(true)).build();
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(clientConfig);
        this.client = factory.getObject();
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.client != null) {
            this.client.shutdownClient();
        }
    }

    @Override
    public JestClient getClient() {
        return this.client;
    }
}

