/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.activeinstalls.internal.server;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.activeinstalls.server.DataManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="activeinstalls")
@Singleton
public class ActiveInstallsScriptService
implements ScriptService {
    public static final String ACTIVEINSTALLS_ERROR_KEY = "scriptservice.activeinstalls.error";
    @Inject
    private Execution execution;
    @Inject
    private DataManager dataManager;

    public long getTotalInstalls() {
        this.setError(null);
        long result = -1L;
        try {
            result = this.dataManager.getTotalInstalls();
        }
        catch (Exception e) {
            this.setError(e);
        }
        return result;
    }

    public long getActiveInstalls(int days) {
        this.setError(null);
        long result = -1L;
        try {
            result = this.dataManager.getActiveInstalls(days);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return result;
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ACTIVEINSTALLS_ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(ACTIVEINSTALLS_ERROR_KEY, (Object)e);
    }
}

