/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.eventstreambridge;

import com.xpn.xwiki.plugin.activitystream.api.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEventStatus;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityEventImpl;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityEventStatusImpl;
import java.net.MalformedURLException;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;

@Component(roles={EventConverter.class})
@Singleton
public class EventConverter {
    @Inject
    private EventFactory eventFactory;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactSerializer;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> explicitResolver;

    public ActivityEvent convertEventToActivity(Event e) {
        ActivityEventImpl result = new ActivityEventImpl();
        result.setApplication(e.getApplication());
        result.setBody(e.getBody());
        result.setDate(e.getDate());
        result.setEventId(e.getId());
        result.setPage((String)this.compactSerializer.serialize((EntityReference)e.getDocument(), new Object[]{e.getWiki()}));
        if (e.getDocumentTitle() != null) {
            result.setParam1(e.getDocumentTitle());
        }
        if (e.getRelatedEntity() != null) {
            result.setParam2((String)this.serializer.serialize(e.getRelatedEntity(), new Object[0]));
        }
        result.setPriority((e.getImportance().ordinal() + 1) * 10);
        result.setRequestId(e.getGroupId());
        result.setSpace((String)this.compactSerializer.serialize((EntityReference)e.getSpace(), new Object[]{e.getWiki()}));
        result.setStream(e.getStream());
        result.setTitle(e.getTitle());
        result.setType(e.getType());
        if (e.getUrl() != null) {
            result.setUrl(e.getUrl().toString());
        }
        result.setUser((String)this.serializer.serialize((EntityReference)e.getUser(), new Object[0]));
        result.setVersion(e.getDocumentVersion());
        result.setWiki((String)this.serializer.serialize((EntityReference)e.getWiki(), new Object[0]));
        result.setParameters(e.getParameters());
        result.setTarget(e.getTarget());
        return result;
    }

    public Event convertActivityToEvent(ActivityEvent e) {
        int priority;
        Event result = this.eventFactory.createRawEvent();
        result.setApplication(e.getApplication());
        result.setBody(e.getBody());
        result.setDate(e.getDate());
        result.setDocument(new DocumentReference(this.resolver.resolve((Object)e.getPage(), EntityType.DOCUMENT, new Object[]{new WikiReference(e.getWiki())})));
        result.setId(e.getEventId());
        result.setDocumentTitle(e.getParam1());
        if (StringUtils.isNotEmpty((CharSequence)e.getParam2())) {
            if (StringUtils.endsWith((CharSequence)e.getType(), (CharSequence)"Attachment")) {
                result.setRelatedEntity(this.explicitResolver.resolve((Object)e.getParam2(), EntityType.ATTACHMENT, new Object[]{result.getDocument()}));
            } else if (StringUtils.endsWith((CharSequence)e.getType(), (CharSequence)"Comment") || StringUtils.endsWith((CharSequence)e.getType(), (CharSequence)"Annotation")) {
                result.setRelatedEntity(this.explicitResolver.resolve((Object)e.getParam2(), EntityType.OBJECT, new Object[]{result.getDocument()}));
            }
        }
        result.setImportance(Event.Importance.MEDIUM);
        if (e.getPriority() > 0 && (priority = e.getPriority() / 10 - 1) >= 0 && priority < Event.Importance.values().length) {
            result.setImportance(Event.Importance.values()[priority]);
        }
        result.setGroupId(e.getRequestId());
        result.setStream(e.getStream());
        result.setTitle(e.getTitle());
        result.setType(e.getType());
        if (StringUtils.isNotBlank((CharSequence)e.getUrl())) {
            try {
                result.setUrl(new URL(e.getUrl()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        result.setUser(new DocumentReference(this.resolver.resolve((Object)e.getUser(), EntityType.DOCUMENT, new Object[0])));
        result.setDocumentVersion(e.getVersion());
        result.setParameters(e.getParameters());
        result.setTarget(e.getTarget());
        return result;
    }

    public ActivityEventStatus convertEventStatusToActivityStatus(EventStatus eventStatus) {
        ActivityEventStatusImpl activityStatus = new ActivityEventStatusImpl();
        activityStatus.setActivityEvent(this.convertEventToActivity(eventStatus.getEvent()));
        activityStatus.setEntityId(eventStatus.getEntityId());
        activityStatus.setRead(eventStatus.isRead());
        return activityStatus;
    }

    public EventStatus convertActivityStatusToEventStatus(ActivityEventStatus eventStatus) {
        return new DefaultEventStatus(this.convertActivityToEvent(eventStatus.getActivityEvent()), eventStatus.getEntityId(), eventStatus.isRead());
    }
}

