/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.internal;

import com.xpn.xwiki.store.hibernate.HibernateSessionFactory;
import com.xpn.xwiki.util.Util;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.ApplicationStartedEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="ActivityStreamMappingInitializer")
@Singleton
public class ActivityStreamMappingInitializer
implements EventListener {
    @Inject
    private HibernateSessionFactory sessionFactory;

    public List<Event> getEvents() {
        return Collections.singletonList(new ApplicationStartedEvent());
    }

    public String getName() {
        return "Activity Stream Mapping Initializer";
    }

    public void onEvent(Event event, Object source, Object data) {
        String driverClass = StringUtils.defaultString((String)this.sessionFactory.getConfiguration().getProperty("hibernate.connection.driver_class"), (String)this.sessionFactory.getConfiguration().getProperty("connection.driver_class"));
        if (StringUtils.containsIgnoreCase((CharSequence)driverClass, (CharSequence)"oracle")) {
            this.sessionFactory.getConfiguration().addInputStream(Util.getResourceAsStream((String)"legacy-activitystream.oracle.hbm.xml"));
        } else {
            this.sessionFactory.getConfiguration().addInputStream(Util.getResourceAsStream((String)"legacy-activitystream.hbm.xml"));
        }
    }
}

