/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.internal;

import com.xpn.xwiki.plugin.activitystream.impl.ActivityStreamImpl;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.eventstream.EventStream;
import org.xwiki.eventstream.RecordableEvent;
import org.xwiki.eventstream.RecordableEventConverter;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

@Component
@Singleton
@Named(value="RecordableEventListener")
public class RecordableEventListener
extends AbstractEventListener {
    @Inject
    private EventStream eventStream;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RecordableEventConverter defaultConverter;
    @Inject
    private RemoteObservationManagerContext remoteObservationManagerContext;
    @Inject
    private Logger logger;
    @Inject
    private Execution execution;

    public RecordableEventListener() {
        super("RecordableEventListener", new Event[]{AllEvent.ALLEVENT});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (!(event instanceof RecordableEvent) || this.remoteObservationManagerContext.isRemoteState()) {
            return;
        }
        for (Event ignoredEvent : ActivityStreamImpl.LISTENER_EVENTS) {
            if (!ignoredEvent.matches((Object)event)) continue;
            return;
        }
        try {
            if (!this.execution.getContext().hasProperty("eventLoopContextLockProperty")) {
                this.execution.getContext().setProperty("eventLoopContextLockProperty", (Object)true);
                this.eventStream.addEvent(this.convertEvent(event, source, data));
                this.execution.getContext().removeProperty("eventLoopContextLockProperty");
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to save the event [{}].", (Object)event.getClass().getCanonicalName(), (Object)e);
        }
    }

    private org.xwiki.eventstream.Event convertEvent(Event event, Object source, Object data) throws Exception {
        for (RecordableEventConverter converter : this.componentManager.getInstanceList(RecordableEventConverter.class)) {
            if (converter == this.defaultConverter) continue;
            for (RecordableEvent ev : converter.getSupportedEvents()) {
                if (!ev.matches((Object)event)) continue;
                return converter.convert((RecordableEvent)event, (String)source, data);
            }
        }
        return this.defaultConverter.convert((RecordableEvent)event, (String)source, data);
    }
}

