/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityEventImpl;
import com.xpn.xwiki.store.XWikiHibernateStore;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Named(value="R93000RecordableEventMigrator")
@Singleton
public class RecordableEventMigrator
extends AbstractHibernateDataMigration {
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "https://jira.xwiki.org/browse/XWIKI-14172";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(93000);
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        String hql = "select event from ActivityEventImpl event where event.page LIKE concat(event.wiki, ':%')";
        try {
            List events;
            do {
                Query query = this.queryManager.createQuery(hql, "hql");
                query.setLimit(50);
                events = query.execute();
                for (ActivityEventImpl event : events) {
                    this.fixEvent(event);
                }
            } while (!events.isEmpty());
        }
        catch (QueryException e) {
            throw new DataMigrationException("Failed to fix RecordableEvent problems.", (Throwable)e);
        }
    }

    private void fixEvent(ActivityEventImpl event) {
        String fullName = event.getPage();
        event.setPage(fullName.substring(String.format("%s:", event.getWiki()).length()));
        this.saveEvent(event);
    }

    private void saveEvent(ActivityEventImpl event) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
        try {
            hibernateStore.beginTransaction(context);
            Session session = hibernateStore.getSession(context);
            session.update((Object)event);
            hibernateStore.endTransaction(context, true);
        }
        catch (XWikiException e) {
            hibernateStore.endTransaction(context, false);
            this.logger.warn("Failed to update the event [{}].", (Object)event.getEventId());
        }
    }
}

