/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.activitystream.eventstreambridge;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.plugin.activitystream.api.ActivityEvent;
import com.xpn.xwiki.plugin.activitystream.api.ActivityStreamException;
import com.xpn.xwiki.plugin.activitystream.impl.ActivityEventImpl;
import com.xpn.xwiki.plugin.activitystream.plugin.ActivityStreamPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.eventstream.EventGroup;
import org.xwiki.eventstream.EventStream;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class BridgeEventStream
implements EventStream {
    @Inject
    private EventFactory eventFactory;
    @Inject
    private Execution execution;
    @Inject
    private QueryManager qm;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    @Named(value="explicit")
    private EntityReferenceResolver<String> explicitResolver;

    public void addEvent(Event e) {
        try {
            XWikiContext context = this.getXWikiContext();
            ActivityStreamPlugin plugin = this.getPlugin(context);
            plugin.getActivityStream().addActivityEvent(this.convertEventToActivity(e), context);
        }
        catch (ActivityStreamException activityStreamException) {
            // empty catch block
        }
    }

    public void deleteEvent(Event e) {
        try {
            XWikiContext context = this.getXWikiContext();
            ActivityStreamPlugin plugin = this.getPlugin(context);
            plugin.getActivityStream().deleteActivityEvent(this.convertEventToActivity(e), context);
        }
        catch (ActivityStreamException activityStreamException) {
            // empty catch block
        }
    }

    public EventGroup getRelatedEvents(Event e) {
        XWikiContext context = this.getXWikiContext();
        ActivityStreamPlugin plugin = this.getPlugin(context);
        EventGroup result = new EventGroup();
        try {
            result.addEvents(this.convertActivitiesToEvents(plugin.getActivityStream().getRelatedEvents(this.convertEventToActivity(e), context)).toArray(new Event[0]));
        }
        catch (ActivityStreamException ex) {
            // empty catch block
        }
        return result;
    }

    public List<Event> searchEvents(Query query) throws QueryException {
        Query q = this.qm.createQuery("select event from ActivityEventImpl event " + query.getStatement(), query.getLanguage());
        for (Map.Entry entry : query.getNamedParameters().entrySet()) {
            q.bindValue((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : query.getPositionalParameters().entrySet()) {
            q.bindValue(((Integer)entry.getKey()).intValue(), entry.getValue());
        }
        q.setLimit(query.getLimit());
        q.setOffset(query.getOffset());
        List events = q.execute();
        return this.convertActivitiesToEvents(events);
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    private ActivityStreamPlugin getPlugin(XWikiContext context) {
        return (ActivityStreamPlugin)context.getWiki().getPlugin("activitystream", context);
    }

    private ActivityEvent convertEventToActivity(Event e) {
        ActivityEventImpl result = new ActivityEventImpl();
        result.setApplication(e.getApplication());
        result.setBody(e.getBody());
        result.setDate(e.getDate());
        result.setEventId(e.getId());
        result.setPage((String)this.serializer.serialize((EntityReference)e.getDocument(), new Object[0]));
        if (e.getDocumentTitle() != null) {
            result.setParam1(e.getDocumentTitle());
        }
        if (e.getRelatedEntity() != null) {
            result.setParam2((String)this.serializer.serialize(e.getRelatedEntity(), new Object[0]));
        }
        result.setPriority((e.getImportance().ordinal() + 1) * 10);
        result.setRequestId(e.getGroupId());
        result.setSpace((String)this.localSerializer.serialize((EntityReference)e.getSpace(), new Object[0]));
        result.setStream(e.getStream());
        result.setTitle(e.getTitle());
        result.setType(e.getType());
        if (e.getUrl() != null) {
            result.setUrl(e.getUrl().toString());
        }
        result.setUser((String)this.serializer.serialize((EntityReference)e.getUser(), new Object[0]));
        result.setVersion(e.getDocumentVersion());
        result.setWiki((String)this.serializer.serialize((EntityReference)e.getWiki(), new Object[0]));
        result.setParameters(e.getParameters());
        return result;
    }

    private List<Event> convertActivitiesToEvents(List<ActivityEvent> events) {
        ArrayList<Event> result = new ArrayList<Event>(events.size());
        for (ActivityEvent e : events) {
            result.add(this.convertActivityToEvent(e));
        }
        return result;
    }

    private Event convertActivityToEvent(ActivityEvent e) {
        int priority;
        Event result = this.eventFactory.createRawEvent();
        result.setApplication(e.getApplication());
        result.setBody(e.getBody());
        result.setDate(e.getDate());
        result.setDocument(new DocumentReference(this.resolver.resolve((Object)e.getPage(), EntityType.DOCUMENT, new Object[0])));
        result.setId(e.getEventId());
        result.setDocumentTitle(e.getParam1());
        if (StringUtils.isNotEmpty((CharSequence)e.getParam2())) {
            if (StringUtils.endsWith((CharSequence)e.getType(), (CharSequence)"Attachment")) {
                result.setRelatedEntity(this.explicitResolver.resolve((Object)e.getParam2(), EntityType.ATTACHMENT, new Object[]{result.getDocument()}));
            } else if (StringUtils.endsWith((CharSequence)e.getType(), (CharSequence)"Comment") || StringUtils.endsWith((CharSequence)e.getType(), (CharSequence)"Annotation")) {
                result.setRelatedEntity(this.explicitResolver.resolve((Object)e.getParam2(), EntityType.OBJECT, new Object[]{result.getDocument()}));
            }
        }
        result.setImportance(Event.Importance.MEDIUM);
        if (e.getPriority() > 0 && (priority = e.getPriority() / 10 - 1) >= 0 && priority < Event.Importance.values().length) {
            result.setImportance(Event.Importance.values()[priority]);
        }
        result.setGroupId(e.getRequestId());
        result.setStream(e.getStream());
        result.setTitle(e.getTitle());
        result.setType(e.getType());
        if (StringUtils.isNotBlank((CharSequence)e.getUrl())) {
            try {
                result.setUrl(new URL(e.getUrl()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        result.setUser(new DocumentReference(this.resolver.resolve((Object)e.getUser(), EntityType.DOCUMENT, new Object[0])));
        result.setDocumentVersion(e.getVersion());
        result.setParameters(e.getParameters());
        return result;
    }
}

