/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.annotation.AnnotationServiceException;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Role;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.event.filter.EventFilter;
import org.xwiki.observation.event.filter.RegexEventFilter;

@Role
@Named(value="CheckAnnotationClassEventListener")
@Singleton
public class CheckAnnotationClassEventListener
implements EventListener {
    private static final RegexEventFilter CONFIGURATION_DOCUMENT_REFERENCE = new RegexEventFilter(String.format(".*:%s.%s", "AnnotationCode", "AnnotationConfig"));
    private static final List<Event> EVENTS = Arrays.asList(new ApplicationReadyEvent(), new DocumentUpdatedEvent((EventFilter)CONFIGURATION_DOCUMENT_REFERENCE), new DocumentCreatedEvent((EventFilter)CONFIGURATION_DOCUMENT_REFERENCE));
    @Inject
    protected Logger logger;
    @Inject
    protected Execution execution;
    @Inject
    protected AnnotationConfiguration configuration;
    @Inject
    protected EntityReferenceSerializer<String> serializer;

    public String getName() {
        return this.getClass().getAnnotation(Named.class).value();
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        block7: {
            try {
                XWikiContext deprecatedContext = this.getXWikiContext();
                XWiki xwiki = deprecatedContext.getWiki();
                if (event instanceof ApplicationReadyEvent) {
                    String currentDatabase = deprecatedContext.getDatabase();
                    try {
                        for (String wikiName : xwiki.getVirtualWikisDatabaseNames(deprecatedContext)) {
                            deprecatedContext.setDatabase(wikiName);
                            this.ensureAnnotationClassIsValid();
                        }
                        break block7;
                    }
                    finally {
                        deprecatedContext.setDatabase(currentDatabase);
                    }
                }
                this.ensureAnnotationClassIsValid();
            }
            catch (Exception e) {
                this.logger.error("Failed to update the configured annotation class for wiki [{}] on event [{}]", new Object[]{this.getXWikiContext().getDatabase(), event.getClass().getSimpleName(), e});
            }
        }
    }

    private void ensureAnnotationClassIsValid() throws AnnotationServiceException {
        DocumentReference annotationClassReference = null;
        try {
            if (!this.configuration.isInstalled()) {
                return;
            }
            annotationClassReference = this.configuration.getAnnotationClassReference();
            XWikiContext deprecatedContext = this.getXWikiContext();
            XWikiDocument annotationClassDocument = deprecatedContext.getWiki().getDocument(annotationClassReference, deprecatedContext);
            BaseClass annotationClass = annotationClassDocument.getXClass();
            boolean needsUpdate = false;
            needsUpdate |= annotationClass.addTextField("author", "Author", 30);
            needsUpdate |= annotationClass.addDateField("date", "Date");
            needsUpdate |= annotationClass.addTextAreaField("selection", "Selection", 40, 5);
            needsUpdate |= annotationClass.addTextAreaField("selectionLeftContext", "Selection Left Context", 40, 5);
            needsUpdate |= annotationClass.addTextAreaField("selectionRightContext", "Selection Right Context", 40, 5);
            needsUpdate |= annotationClass.addTextAreaField("originalSelection", "Original Selection", 40, 5);
            needsUpdate |= annotationClass.addTextField("target", "Target", 30);
            needsUpdate |= annotationClass.addTextField("state", "State", 30);
            if (annotationClassDocument.getCreatorReference() == null) {
                needsUpdate = true;
                annotationClassDocument.setCreator("superadmin");
            }
            if (annotationClassDocument.getAuthorReference() == null) {
                needsUpdate = true;
                annotationClassDocument.setAuthorReference(annotationClassDocument.getCreatorReference());
            }
            if (needsUpdate) {
                deprecatedContext.getWiki().saveDocument(annotationClassDocument, "Automatically added missing annotation class fields required by the Annotation Application.", deprecatedContext);
            }
        }
        catch (Exception e) {
            throw new AnnotationServiceException(String.format("Failed to update the configured annotation class [%s]", annotationClassReference.toString()), (Throwable)e);
        }
    }

    private XWikiContext getXWikiContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }
}

