/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.annotation.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.mandatory.AbstractMandatoryDocumentInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.annotation.AnnotationConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="annotationclass")
@Singleton
public class AnnotationClassDocumentInitializer
extends AbstractMandatoryDocumentInitializer {
    static final String HINT = "annotationclass";
    @Inject
    protected AnnotationConfiguration configuration;

    public AnnotationClassDocumentInitializer() {
        super(null);
    }

    public EntityReference getDocumentReference() {
        return this.configuration.getAnnotationClassReference();
    }

    public boolean updateDocument(XWikiDocument document) {
        if (!this.configuration.isInstalled()) {
            return false;
        }
        BaseClass annotationClass = document.getXClass();
        boolean needsUpdate = false;
        needsUpdate |= annotationClass.addTextField("author", "Author", 30);
        needsUpdate |= annotationClass.addDateField("date", "Date");
        needsUpdate |= annotationClass.addTextAreaField("selection", "Selection", 40, 5);
        needsUpdate |= annotationClass.addTextAreaField("selectionLeftContext", "Selection Left Context", 40, 5);
        needsUpdate |= annotationClass.addTextAreaField("selectionRightContext", "Selection Right Context", 40, 5);
        needsUpdate |= annotationClass.addTextAreaField("originalSelection", "Original Selection", 40, 5);
        needsUpdate |= annotationClass.addTextField("target", "Target", 30);
        needsUpdate |= annotationClass.addTextField("state", "State", 30);
        return needsUpdate |= this.setClassDocumentFields(document, "Annotation Class");
    }
}

